package com.atlassian.plugins.whitelist;

import javax.annotation.Nullable;

import com.google.common.base.Function;

/**
 * @since 1.0
 */
public class ImmutableWhitelistRuleBuilder
{
    public static final Function<WhitelistRule,WhitelistRule> COPY = new Function<WhitelistRule, WhitelistRule>()
    {
        @Override
        public WhitelistRule apply(@Nullable final WhitelistRule input)
        {
            return input != null ? ImmutableWhitelistRule.builder().copyOf(input).build() : null;
        }
    };

    Integer id;
    String expression;
    WhitelistType type;
    boolean allowInbound;

    public ImmutableWhitelistRuleBuilder copyOf(final WhitelistRule template)
    {
        return id(template.getId())
                .expression(template.getExpression())
                .type(template.getType())
                .allowInbound(template.isAllowInbound());
    }

    public ImmutableWhitelistRuleBuilder id(final Integer id)
    {
        this.id = id;
        return this;
    }

    public ImmutableWhitelistRuleBuilder expression(final String expression)
    {
        this.expression = expression;
        return this;
    }

    public ImmutableWhitelistRuleBuilder type(final WhitelistType type)
    {
        this.type = type;
        return this;
    }

    public ImmutableWhitelistRuleBuilder allowInbound(final boolean allowInbound)
    {
        this.allowInbound = allowInbound;
        return this;
    }

    public ImmutableWhitelistRule build()
    {
        return new ImmutableWhitelistRule(this);
    }
}
