/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistRulePredicates;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.applinks.ApplicationLinkWhitelistRule;
import com.atlassian.plugins.whitelist.applinks.CachingApplicationLinkService;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ApplicationLinkChangeListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLinkChangeListener.class);
    private final EventPublisher eventPublisher;
    private final WhitelistManager whitelistManager;
    private final TransactionTemplate transactionTemplate;
    private final CachingApplicationLinkService cachingApplicationLinkService;
    private boolean started;

    public ApplicationLinkChangeListener(EventPublisher eventPublisher, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate, CachingApplicationLinkService cachingApplicationLinkService) {
        this.eventPublisher = eventPublisher;
        this.whitelistManager = whitelistManager;
        this.transactionTemplate = transactionTemplate;
        this.cachingApplicationLinkService = cachingApplicationLinkService;
    }

    @EventListener
    public void onApplicationLinkAdded(ApplicationLinkAddedEvent event) {
        if (this.started) {
            this.add(event.getApplicationLink());
            this.cachingApplicationLinkService.clear();
        }
    }

    @EventListener
    public void onApplicationLinkDetailsChangedEvent(ApplicationLinkDetailsChangedEvent event) {
        if (this.started) {
            this.cachingApplicationLinkService.clear();
        }
    }

    @EventListener
    public void onApplicationLinkIdChanged(ApplicationLinksIDChangedEvent event) {
        if (this.started) {
            this.update(event.getOldApplicationId(), event.getApplicationLink());
            this.cachingApplicationLinkService.clear();
        }
    }

    @EventListener
    public void onApplicationLinkDeleted(ApplicationLinkDeletedEvent event) {
        if (this.started) {
            this.remove(event.getApplicationLink().getId());
            this.cachingApplicationLinkService.clear();
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        final Collection whitelistedApplicationLinkIds = Collections2.transform((Collection)Collections2.filter(this.whitelistManager.getAll(), WhitelistRulePredicates.withType(WhitelistType.APPLICATION_LINK)), (Function)new Function<WhitelistRule, String>(){

            public String apply(WhitelistRule whitelistRule) {
                return whitelistRule.getExpression();
            }
        });
        Iterable nonWhitelistedApplicationLinks = Iterables.filter(this.cachingApplicationLinkService.getApplicationLinks(), (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(ApplicationLink applicationLink) {
                return !whitelistedApplicationLinkIds.contains(applicationLink.getId().get());
            }
        });
        this.add(nonWhitelistedApplicationLinks);
        this.started = true;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private void add(final ApplicationLink applicationLink) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                Collection existingRules = ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(applicationLink.getId());
                if (existingRules.isEmpty()) {
                    ApplicationLinkChangeListener.this.whitelistManager.add(new ApplicationLinkWhitelistRule(applicationLink));
                }
                return null;
            }
        });
    }

    private void add(final Iterable<ApplicationLink> applicationLinks) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                for (ApplicationLink applicationLink : applicationLinks) {
                    ApplicationLinkChangeListener.this.whitelistManager.add(new ApplicationLinkWhitelistRule(applicationLink));
                }
                return null;
            }
        });
    }

    private void update(final ApplicationId oldApplicationId, final ApplicationLink applicationLink) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                LinkedList applinksWithOldApplicationId = Lists.newLinkedList((Iterable)ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(oldApplicationId));
                WhitelistRule first = (WhitelistRule)applinksWithOldApplicationId.pollFirst();
                if (first != null) {
                    ImmutableWhitelistRule expression = ImmutableWhitelistRule.builder().copyOf(first).expression(ApplicationLinkWhitelistRule.getExpressionFrom(applicationLink)).build();
                    ApplicationLinkChangeListener.this.whitelistManager.update(expression);
                }
                ApplicationLinkChangeListener.this.whitelistManager.removeAll(applinksWithOldApplicationId);
                return null;
            }
        });
    }

    private void remove(final ApplicationId applicationId) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                Collection applinksWithId = ApplicationLinkChangeListener.this.findAllWhitelistedApplicationLinksWithId(applicationId);
                ApplicationLinkChangeListener.this.whitelistManager.removeAll(applinksWithId);
                return null;
            }
        });
    }

    private Collection<WhitelistRule> findAllWhitelistedApplicationLinksWithId(ApplicationId applicationId) {
        String expression = ApplicationLinkWhitelistRule.getExpressionFrom(applicationId);
        WhitelistType type = WhitelistType.APPLICATION_LINK;
        Collection result = Collections2.filter(this.whitelistManager.getAll(), (Predicate)Predicates.and(WhitelistRulePredicates.withType(type), WhitelistRulePredicates.withExpression(expression)));
        if (result.size() > 1) {
            logger.warn("Found more than one whitelist entry for the application link with id '{}'.", (Object)applicationId);
        }
        return result;
    }
}

