/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.applinks.ApplicationLinkMatcher;
import com.atlassian.plugins.whitelist.applinks.CachingApplicationLinkService;
import com.atlassian.plugins.whitelist.matcher.DomainNameMatcher;
import com.atlassian.plugins.whitelist.matcher.ExactUrlMatcher;
import com.atlassian.plugins.whitelist.matcher.RegularExpressionMatcher;
import com.atlassian.plugins.whitelist.matcher.WildcardExpressionMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultWhitelistRuleMatcher
implements Predicate<URI> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWhitelistRuleMatcher.class);
    private final CachingApplicationLinkService applicationLinkService;
    private final WhitelistRule whitelistRule;
    private final ImmutableMap<WhitelistType, Function<WhitelistRule, Predicate<URI>>> mappings = ImmutableMap.of((Object)((Object)WhitelistType.APPLICATION_LINK), this.createApplicationLinkRule(), (Object)((Object)WhitelistType.EXACT_URL), this.createExactUrlRule(), (Object)((Object)WhitelistType.WILDCARD_EXPRESSION), this.createWildcardExpressionRule(), (Object)((Object)WhitelistType.REGULAR_EXPRESSION), this.createRegularExpressionRule(), (Object)((Object)WhitelistType.DOMAIN_NAME), this.createDomainNameRule());

    public DefaultWhitelistRuleMatcher(CachingApplicationLinkService applicationLinkService, WhitelistRule whitelistRule) {
        this.applicationLinkService = (CachingApplicationLinkService)Preconditions.checkNotNull((Object)applicationLinkService, (Object)"applicationLinkService");
        this.whitelistRule = whitelistRule;
    }

    public boolean apply(URI uri) {
        Preconditions.checkNotNull((Object)this.whitelistRule, (Object)"whitelistRule");
        WhitelistType type = this.whitelistRule.getType();
        Function mapping = (Function)this.mappings.get((Object)type);
        if (mapping == null) {
            logger.debug("No mapping found for whitelist type '{}', ignoring data '{}'.", (Object)type, (Object)this.whitelistRule);
            return false;
        }
        try {
            return ((Predicate)mapping.apply((Object)this.whitelistRule)).apply((Object)uri);
        }
        catch (RuntimeException e) {
            logger.debug("Failed to match '{}' with whitelist rule '{}'", new Object[]{uri, this.whitelistRule, e});
            return false;
        }
    }

    private Function<WhitelistRule, Predicate<URI>> createApplicationLinkRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                String applicationId = input.getExpression();
                ApplicationLink applicationLink = DefaultWhitelistRuleMatcher.this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
                if (applicationLink == null) {
                    throw new IllegalArgumentException("Failed to resolved application link with application id '" + applicationId + "'; may be it has been removed and the whitelist was not updated?");
                }
                return this.createWhitelistRule(applicationLink);
            }

            private Predicate<URI> createWhitelistRule(ApplicationLink applicationLink) {
                return new ApplicationLinkMatcher(applicationLink);
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createExactUrlRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new ExactUrlMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createWildcardExpressionRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new WildcardExpressionMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createRegularExpressionRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new RegularExpressionMatcher(input.getExpression());
            }
        };
    }

    private Function<WhitelistRule, Predicate<URI>> createDomainNameRule() {
        return new Function<WhitelistRule, Predicate<URI>>(){

            public Predicate<URI> apply(WhitelistRule input) {
                return new DomainNameMatcher(input.getExpression());
            }
        };
    }
}

