package com.atlassian.plugins.whitelist.migration.confluence;

import com.atlassian.confluence.setup.bandana.BandanaSerializer;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

/**
 * Return the raw string value stored in Bandana. Used to avoid the class casting the default implementation is doing.
 * @since 1.0
 */
class RawStringBandanaDeserializer implements BandanaSerializer
{
    @Override
    public void serialize(final Object obj, final Writer writer) throws IOException
    {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object deserialize(final Reader reader) throws IOException
    {
        return IOUtils.toString(reader);
    }
}
