package com.atlassian.plugins.whitelist.matcher;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * @since 1.1
 */
public class MatcherUtils
{
    /**
     * @param uri the URI to be processed
     * @return an URI suitable to compare it against whitelist rules (e.g. remove any user info).
     * @throws URISyntaxException
     */
    public static URI normalizeUri(final URI uri) throws URISyntaxException
    {
        if (uri.getScheme() == null)
        {
            throw new URISyntaxException(uri.toString(), "Expected scheme at index 0: " + uri, 0);
        }
        if (uri.getHost() == null)
        {
            final int index = uri.getScheme().length() + "://".length();
            throw new URISyntaxException(uri.toString(), "Expected host at index " + index + ": " + uri, index);
        }
        if (uri.getUserInfo() == null && uri.getFragment() == null)
        {
            return uri;
        }
        return new URI(uri.getScheme().toLowerCase(), null, uri.getHost().toLowerCase(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
    }

    public static URI normalizeUriUnchecked(final URI uri)
    {
        try
        {
            return normalizeUri(uri);
        }
        catch (URISyntaxException x)
        {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }
}
