package com.atlassian.plugins.whitelist.caching;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.plugins.whitelist.applinks.CachingApplicationLinkService;
import com.atlassian.plugins.whitelist.events.ClearWhitelistCacheEvent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/**
 * Invalidate the local caches on every event fired in JIRA.
 * @since 1.2
 */
public class JiraClearCacheEventAdapter implements InitializingBean, DisposableBean
{
    private final EventPublisher eventPublisher;
    private final CachingApplicationLinkService cachingApplicationLinkService;

    public JiraClearCacheEventAdapter(final EventPublisher eventPublisher, final CachingApplicationLinkService cachingApplicationLinkService)
    {
        this.eventPublisher = eventPublisher;
        this.cachingApplicationLinkService = cachingApplicationLinkService;
    }

    @Override
    public void destroy() throws Exception
    {
        eventPublisher.register(this);
    }

    @Override
    public void afterPropertiesSet() throws Exception
    {
        eventPublisher.unregister(this);
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onClearCacheEvent(final ClearCacheEvent event)
    {
        cachingApplicationLinkService.clear();
        eventPublisher.publish(new ClearWhitelistCacheEvent());
    }
}
