package com.atlassian.plugins.whitelist.caching;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.ClearHttpCacheEvent;
import com.atlassian.plugins.whitelist.events.WhitelistDisabledEvent;
import com.atlassian.plugins.whitelist.events.WhitelistEnabledEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleAddedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleChangedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleRemovedEvent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/**
 * Translate whitelist rule events to {@link ClearHttpCacheEvent}s. This is designed to clear the Gadget's cache after
 * the whitelist has been modified.
 * @since 1.0
 */
public class GadgetsClearHttpCacheAdapter implements InitializingBean, DisposableBean
{
    private final EventPublisher eventPublisher;

    public GadgetsClearHttpCacheAdapter(final EventPublisher eventPublisher)
    {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void destroy() throws Exception
    {
        eventPublisher.unregister(this);
    }

    @Override
    public void afterPropertiesSet() throws Exception
    {
        eventPublisher.register(this);
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onWhitelistEnabled(final WhitelistEnabledEvent event)
    {
        publishClearCacheEvent();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onWhitelistDisabled(final WhitelistDisabledEvent event)
    {
        publishClearCacheEvent();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onWhitelistRuleAdded(final WhitelistRuleAddedEvent event)
    {
        publishClearCacheEvent();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onWhitelistRuleChanged(final WhitelistRuleChangedEvent event)
    {
        publishClearCacheEvent();
    }

    @EventListener
    @SuppressWarnings("UnusedParameters")
    public void onWhitelistRuleRemoved(final WhitelistRuleRemovedEvent event)
    {
        publishClearCacheEvent();
    }

    private void publishClearCacheEvent()
    {
        eventPublisher.publish(ClearHttpCacheEvent.INSTANCE);
    }
}
