package com.atlassian.plugins.whitelist.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class ApplicationLinkWhitelistRule implements WhitelistRule
{
    private final ApplicationLink applicationLink;

    public ApplicationLinkWhitelistRule(final ApplicationLink applicationLink)
    {
        this.applicationLink = checkNotNull(applicationLink, "applicationLink");
    }

    @Override
    public Integer getId()
    {
        return null;
    }

    @Override
    public String getExpression()
    {
        return getExpressionFrom(applicationLink);
    }

    @Override
    public WhitelistType getType()
    {
        return WhitelistType.APPLICATION_LINK;
    }

    @Override
    public boolean isAllowInbound()
    {
        return false;
    }

    public static String getExpressionFrom(final ApplicationId applicationId)
    {
        checkNotNull(applicationId, "applicationId");
        return applicationId.get();
    }

    public static String getExpressionFrom(final ApplicationLink applicationLink)
    {
        checkNotNull(applicationLink, "applicationLink");
        return getExpressionFrom(applicationLink.getId());
    }
}
