package com.atlassian.plugins.whitelist.applinks;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugins.whitelist.matcher.MatcherUtils;
import com.google.common.base.Predicate;

import java.net.URI;
import java.net.URISyntaxException;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class ApplicationLinkMatcher implements Predicate<URI>
{
    private String applinkRpcUrl;

    public ApplicationLinkMatcher(final ApplicationLink applicationLink)
    {
        this.applinkRpcUrl = checkNotNull(applicationLink, "applicationLink").getRpcUrl().toString();
    }

    @Override
    public boolean apply(final URI uri)
    {
        try
        {
            return MatcherUtils.normalizeUri(uri).toString().startsWith(applinkRpcUrl);
        }
        catch (URISyntaxException e)
        {
            return false;
        }
    }
}
