package com.atlassian.plugins.whitelist.ao;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

/**
 * Represents a single whitelist rule. One size fits all.
 * @since 1.0
 */
@Table("WHITELIST_RULES")
@Preload
public interface AoWhitelistRule extends WhitelistRule, RawEntity<Integer>
{
    String ID_COLUMN = "ID";
    String EXPRESSION_COLUMN = "EXPRESSION";
    String TYPE_COLUMN = "TYPE";
    String ALLOW_INBOUND_COLUMN = "ALLOWINBOUND";

    @AutoIncrement
    @NotNull
    @PrimaryKey(ID_COLUMN)
    Integer getId();

    @Accessor(EXPRESSION_COLUMN)
    @NotNull
    @StringLength(StringLength.UNLIMITED)
    String getExpression();

    @Mutator(EXPRESSION_COLUMN)
    void setExpression(String expression);

    @Accessor(TYPE_COLUMN)
    @NotNull
    WhitelistType getType();

    @Mutator(TYPE_COLUMN)
    void setType(WhitelistType type);

    @Accessor(ALLOW_INBOUND_COLUMN)
    boolean isAllowInbound();

    @Mutator(ALLOW_INBOUND_COLUMN)
    void setAllowInbound(boolean allowInbound);
}
