package com.atlassian.plugins.whitelist;

import com.google.common.base.Predicate;

import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class WhitelistRulePredicates
{
    public static Predicate<WhitelistRule> withId(final int id)
    {
        return new Predicate<WhitelistRule>()
        {
            @Override
            public boolean apply(@Nullable final WhitelistRule input)
            {
                final Integer whitelistRuleId = input != null ? input.getId() : null;
                return whitelistRuleId != null && id == whitelistRuleId;
            }
        };
    }

    public static Predicate<WhitelistRule> withType(final WhitelistType type)
    {
        checkNotNull(type, "type");
        return new Predicate<WhitelistRule>()
        {
            @Override
            public boolean apply(@Nullable final WhitelistRule input)
            {
                return input != null && type == input.getType();
            }
        };
    }

    public static Predicate<WhitelistRule> withExpression(final String expression)
    {
        checkNotNull(expression, "expression");
        return new Predicate<WhitelistRule>()
        {
            @Override
            public boolean apply(@Nullable final WhitelistRule input)
            {
                return input != null && expression.equals(input.getExpression());
            }
        };
    }

}
