package com.atlassian.plugins.whitelist;

import com.atlassian.plugins.whitelist.applinks.CachingApplicationLinkService;
import com.atlassian.plugins.whitelist.matcher.SelfUrlMatcher;

import java.net.URI;

/**
 * since 1.1
 */
class InboundWhitelistImpl extends AbstractWhitelist implements InboundWhitelist
{
    public InboundWhitelistImpl(final WhitelistOnOffSwitch whitelistOnOffSwitch, final WhitelistService whitelistService, final SelfUrlMatcher selfUrlMatcher, final CachingApplicationLinkService applicationLinkService)
    {
        super(whitelistOnOffSwitch, whitelistService, selfUrlMatcher, applicationLinkService);
    }

    @Override
    protected boolean matches(final WhitelistRule whitelistRule, final URI uri)
    {
        return whitelistRule.isAllowInbound() && super.matches(whitelistRule, uri);
    }
}
