/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.rest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.impl.RemoteEventCapabilityRegistrar;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
public class RemoteEventConsumerResource {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventConsumerResource.class);
    private final RemoteEventCapabilityRegistrar capabilityRegistrar;
    private final RequestAuthorizor requestAuthorizor;
    private final EventPublisher eventPublisher;
    private final JsonUtil remoteEventJsonUtil;
    private final HttpUtil httpUtil;

    public RemoteEventConsumerResource(RemoteEventCapabilityRegistrar capabilityRegistrar, RequestAuthorizor requestAuthorizor, EventPublisher eventPublisher, JsonUtil remoteEventJsonUtil, HttpUtil httpUtil) {
        this.capabilityRegistrar = capabilityRegistrar;
        this.requestAuthorizor = requestAuthorizor;
        this.eventPublisher = eventPublisher;
        this.remoteEventJsonUtil = remoteEventJsonUtil;
        this.httpUtil = httpUtil;
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/events/{capability}")
    public Response receiveEvent(@PathParam(value="capability") String capability, InputStream body, @Context HttpServletRequest request, @HeaderParam(value="X-request-id") String rawRequestId) throws IOException {
        String requestId = StringUtils.defaultIfEmpty((String)rawRequestId, (String)"(X-Request-ID not found)");
        log.debug("Received request {} to capability {}", (Object)requestId, (Object)capability);
        if (this.requestAuthorizor.isAuthorized()) {
            Class<? extends RemoteEvent> capabilityClass = this.capabilityRegistrar.getCapabilityClass(capability);
            if (capabilityClass != null) {
                Collection unmarshal = this.remoteEventJsonUtil.readRemoteEvents(body);
                for (RemoteEvent event : unmarshal) {
                    if (capabilityClass.isAssignableFrom(event.getClass())) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Publishing event %s from request %s to capability %s", event, requestId, capability));
                        }
                        this.eventPublisher.publish((Object)event);
                        continue;
                    }
                    log.debug(String.format("Event %s in request %s sent to wrong capability %s from origin %s(%d)", event, requestId, capability, request.getRemoteHost(), request.getRemotePort()));
                }
                return Response.ok((Object)"OK").build();
            }
            log.debug("Request {} to capability {} not found", (Object)requestId, (Object)capability);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        log.debug("Request {} to capability {} unauthorized", (Object)requestId, (Object)capability);
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="/capabilities")
    @Produces(value={"application/json"})
    public Response returnCapabilities(@Context HttpServletRequest request) throws URISyntaxException {
        String baseUri = RemoteEventConsumerResource.getExternalServletRequest(request, "/rest/remote-event-consumer/latest/events/");
        HashMap<String, URI> capabilities = new HashMap<String, URI>();
        for (String capability : this.capabilityRegistrar.getPublishedCapabilities()) {
            capabilities.put(capability, this.httpUtil.getUrl(baseUri, capability));
        }
        return this.httpUtil.getOkJsonResponse(capabilities);
    }

    @VisibleForTesting
    static String getExternalServletRequest(HttpServletRequest request, String newServletPath) {
        String xForwardedProto = request.getHeader("x-forwarded-proto");
        String scheme = xForwardedProto == null ? request.getScheme() : xForwardedProto;
        String host = request.getServerName();
        int serverPort = request.getServerPort();
        String port = serverPort == 80 || serverPort == 443 ? "" : ":" + serverPort;
        String contextPath = request.getContextPath();
        String context = StringUtils.isBlank((String)contextPath) || contextPath.equals("/") ? "" : contextPath;
        String separator = newServletPath.startsWith("/") ? "" : "/";
        return scheme + "://" + host + port + context + separator + newServletPath;
    }
}

