/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

class JavascriptWebResourceFormatter
extends AbstractWebResourceFormatter {
    private static final String JAVA_SCRIPT_EXTENSION = ".js";
    private static final List HANDLED_PARAMETERS = Arrays.asList("charset");

    JavascriptWebResourceFormatter() {
    }

    public boolean matches(String name) {
        return name != null && name.endsWith(JAVA_SCRIPT_EXTENSION);
    }

    public String formatResource(String name, String url, Map params) {
        StringBuffer buffer = new StringBuffer("<script type=\"text/javascript\" ");
        buffer.append("src=\"").append(url).append("\" ");
        buffer.append(StringUtils.join(this.getParametersAsAttributes(params).iterator(), (String)" "));
        buffer.append("></script>\n");
        return buffer.toString();
    }

    protected List getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

