/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceDownloadUtils {
    private static final Log log = LogFactory.getLog((Class)ResourceDownloadUtils.class);
    private static final long TEN_YEARS = 315360000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveFileImpl(HttpServletResponse httpServletResponse, InputStream in) throws IOException {
        ServletOutputStream out = httpServletResponse.getOutputStream();
        try {
            int read_count;
            byte[] buffer = new byte[16384];
            while ((read_count = in.read(buffer)) != -1) {
                out.write(buffer, 0, read_count);
            }
            log.info((Object)"Serving file done.");
        }
        catch (Exception e) {
            log.info((Object)("I/O Error serving the requested file: " + e.toString()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (Exception e) {
                    log.info((Object)("Error flushing output stream: " + e.toString()));
                }
            }
        }
    }

    public static void addCachingHeaders(HttpServletResponse httpServletResponse) {
        if (!Boolean.getBoolean("atlassian.disable.caches")) {
            httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 315360000000L);
            httpServletResponse.setHeader("Cache-Control", "max-age=315360000000");
            httpServletResponse.addHeader("Cache-Control", "private");
        }
    }

    public static void addCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletResponse);
    }
}

