/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.repositories;

import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginJar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FilePluginInstaller
implements PluginInstaller {
    private File directory;

    public FilePluginInstaller(File directory) {
        this.directory = directory;
    }

    public void installPlugin(String key, PluginJar pluginJar) {
        File newPluginFile = new File(this.directory, pluginJar.getFileName());
        if (newPluginFile.exists()) {
            newPluginFile.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(newPluginFile);
            IOUtils.copy((InputStream)pluginJar.getInputStream(), (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not install plugin: " + pluginJar, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

