/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders.classloading;

import java.io.File;

public class DeploymentUnit
implements Comparable {
    private final File path;
    private long lastModifiedAtTimeOfDeployment;

    public DeploymentUnit(File path) {
        if (path == null) {
            throw new IllegalArgumentException("File should not be null!");
        }
        this.path = path;
        this.lastModifiedAtTimeOfDeployment = path.lastModified();
    }

    public long lastModified() {
        return this.lastModifiedAtTimeOfDeployment;
    }

    public File getPath() {
        return this.path;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DeploymentUnit)) {
            return 1;
        }
        return this.path.compareTo(((DeploymentUnit)o).getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentUnit)) {
            return false;
        }
        DeploymentUnit deploymentUnit = (DeploymentUnit)o;
        if (!this.path.equals(deploymentUnit.path)) {
            return false;
        }
        return this.lastModifiedAtTimeOfDeployment == deploymentUnit.lastModifiedAtTimeOfDeployment;
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (int)(this.lastModifiedAtTimeOfDeployment ^ this.lastModifiedAtTimeOfDeployment >>> 32);
        return result;
    }

    public String toString() {
        return "Unit: " + this.path.toString() + " (" + this.lastModifiedAtTimeOfDeployment + ")";
    }
}

