/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.util.VersionStringComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPlugin
implements Plugin,
Comparable {
    private String name;
    private String i18nNameKey;
    private String key;
    private Map modules = new LinkedHashMap();
    private boolean enabledByDefault = true;
    private PluginInformation pluginInformation;
    private boolean enabled;
    private boolean system;
    private Resourced resources = Resources.EMPTY_RESOURCES;
    private int pluginsVersion = 1;
    private Date dateLoaded = new Date();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aPackage) {
        this.key = aPackage;
    }

    public void addModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        this.modules.put(moduleDescriptor.getKey(), moduleDescriptor);
    }

    public Collection getModuleDescriptors() {
        return this.modules.values();
    }

    public ModuleDescriptor getModuleDescriptor(String key) {
        return (ModuleDescriptor)this.modules.get(key);
    }

    public List getModuleDescriptorsByModuleClass(Class aClass) {
        ArrayList<ModuleDescriptor> result = new ArrayList<ModuleDescriptor>();
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
            Class moduleClass = moduleDescriptor.getModuleClass();
            if (!aClass.isAssignableFrom(moduleClass)) continue;
            result.add(moduleDescriptor);
        }
        return result;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault && (this.pluginInformation == null || this.pluginInformation.satisfiesMinJavaVersion());
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public int getPluginsVersion() {
        return this.pluginsVersion;
    }

    public void setPluginsVersion(int pluginsVersion) {
        this.pluginsVersion = pluginsVersion;
    }

    public PluginInformation getPluginInformation() {
        return this.pluginInformation;
    }

    public void setPluginInformation(PluginInformation pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    public void setResources(Resourced resources) {
        this.resources = resources != null ? resources : Resources.EMPTY_RESOURCES;
    }

    public List getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    public List getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSystemPlugin() {
        return this.system;
    }

    public boolean containsSystemModule() {
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
            if (!moduleDescriptor.isSystemModule()) continue;
            return true;
        }
        return false;
    }

    public void setSystemPlugin(boolean system) {
        this.system = system;
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public int compareTo(Object other) {
        if (!(other instanceof Plugin)) {
            return 1;
        }
        Plugin otherPlugin = (Plugin)other;
        if (!otherPlugin.getKey().equals(this.getKey())) {
            return 1;
        }
        String thisVersion = this.cleanVersionString(this.getPluginInformation().getVersion());
        String otherVersion = this.cleanVersionString(otherPlugin.getPluginInformation().getVersion());
        if (!VersionStringComparator.isValidVersionString(thisVersion)) {
            return -1;
        }
        if (!VersionStringComparator.isValidVersionString(otherVersion)) {
            return -1;
        }
        return new VersionStringComparator().compare(thisVersion, otherVersion);
    }

    private String cleanVersionString(String version) {
        if (version == null || version.trim().equals("")) {
            return "0";
        }
        return version.replaceAll(" ", "");
    }
}

