/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors.servlet;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.servlet.ServletModuleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public abstract class ServletModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware {
    private static final Log log = LogFactory.getLog((Class)ServletModuleDescriptor.class);
    List paths;
    private Map initParams;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        List urlPatterns = element.elements("url-pattern");
        this.paths = new ArrayList(urlPatterns.size());
        Iterator iterator = urlPatterns.iterator();
        while (iterator.hasNext()) {
            Element urlPattern = (Element)iterator.next();
            this.paths.add(urlPattern.getTextTrim());
        }
        this.initParams = new HashMap();
        List paramsList = element.elements("init-param");
        Iterator i = paramsList.iterator();
        while (i.hasNext()) {
            Element initParamEl = (Element)i.next();
            Element paramNameEl = initParamEl.element("param-name");
            Element paramValueEl = initParamEl.element("param-value");
            if (paramNameEl != null && paramValueEl != null) {
                this.initParams.put(paramNameEl.getTextTrim(), paramValueEl.getTextTrim());
                continue;
            }
            log.warn((Object)("Invalid init-param XML for servlet module: " + this.getCompleteKey()));
        }
    }

    public void enabled() {
        this.getServletModuleManager().addModule(this);
    }

    public void disabled() {
        this.getServletModuleManager().removeModule(this);
    }

    public Object getModule() {
        HttpServlet obj = null;
        try {
            if (this.plugin instanceof AutowireCapablePlugin) {
                obj = (HttpServlet)((AutowireCapablePlugin)((Object)this.plugin)).autowire(this.getModuleClass());
            } else {
                obj = (HttpServlet)this.getModuleClass().newInstance();
                this.autowireObject(obj);
            }
        }
        catch (InstantiationException e) {
            log.error((Object)("Error instantiating: " + this.getModuleClass()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Error accessing: " + this.getModuleClass()), (Throwable)e);
        }
        return obj;
    }

    public HttpServlet getServlet() {
        return (HttpServlet)this.getModule();
    }

    public List getPaths() {
        return this.paths;
    }

    public Map getInitParams() {
        return this.initParams;
    }

    protected abstract void autowireObject(Object var1);

    protected abstract ServletModuleManager getServletModuleManager();
}

