/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors.servlet;

import com.atlassian.plugin.descriptors.servlet.ServletModuleDescriptor;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class PluginHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final String basePath;

    public PluginHttpRequestWrapper(HttpServletRequest request, ServletModuleDescriptor descriptor) {
        super(request);
        this.basePath = this.findBasePath(descriptor);
    }

    public String getServletPath() {
        String servletPath = super.getServletPath();
        if (this.basePath != null) {
            servletPath = servletPath + this.basePath;
        }
        return servletPath;
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null && this.basePath != null) {
            return pathInfo.substring(this.basePath.length());
        }
        return pathInfo;
    }

    private String findBasePath(ServletModuleDescriptor descriptor) {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            Iterator pathIterator = descriptor.getPaths().iterator();
            while (pathIterator.hasNext()) {
                String basePath = (String)pathIterator.next();
                if (!this.isPathMapping(basePath) || !pathInfo.startsWith(this.getMappingRootPath(basePath))) continue;
                return this.getMappingRootPath(basePath);
            }
        }
        return null;
    }

    private boolean isPathMapping(String path) {
        return path.startsWith("/") && path.endsWith("/*");
    }

    private String getMappingRootPath(String pathMapping) {
        return pathMapping.substring(0, pathMapping.length() - 2);
    }
}

