/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Log log = LogFactory.getLog((Class)FileUtils.class);

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        FileUtils.copy(input, output);
        FileUtils.shutdownStream(input);
        FileUtils.shutdownStream(output);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return FileUtils.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void shutdownStream(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void shutdownStream(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        if (!srcDir.exists()) {
            throw new IllegalArgumentException("Source dir [" + srcDir + "] does not exist");
        }
        FileUtils.copyDirectory(srcDir, destDir, false);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        File[] files = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            log.debug((Object)(destDir.getAbsolutePath() + " already exists"));
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                File dest = new File(destDir, file.getName());
                if (file.isFile()) {
                    FileUtils.copyFile(file, dest);
                    continue;
                }
                FileUtils.copyDirectory(file, dest, overwrite);
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean noDeleted;
                File file = files[i];
                boolean bl = noDeleted = !file.delete();
                if (!noDeleted || !file.isDirectory()) continue;
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static void extractZipFiles(String zipFileName, File destintationDirectory) {
        try {
            byte[] buf = new byte[1024];
            ZipInputStream zipinputstream = null;
            zipinputstream = new ZipInputStream(new FileInputStream(zipFileName));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                int n;
                String entryName = zipentry.getName();
                String destinationName = destintationDirectory + File.separator + entryName;
                File newFile = new File(entryName);
                String directory = newFile.getParent();
                if (directory == null && newFile.isDirectory()) break;
                FileOutputStream fileoutputstream = new FileOutputStream(destinationName);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            log.error((Object)"Failed to extract zipfile", (Throwable)e);
        }
    }
}

