/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.DownloadableWebResource;
import com.atlassian.plugin.servlet.PluginResource;
import com.atlassian.plugin.servlet.ResourceUrlParser;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginResourceDownload
implements DownloadStrategy {
    private static final Log log = LogFactory.getLog((Class)PluginResourceDownload.class);
    private static final String DOWNLOAD_RESOURCE = "download";
    private final ResourceUrlParser urlParser = new ResourceUrlParser("resources");
    private PluginAccessor pluginAccessor;

    public PluginResourceDownload() {
    }

    public PluginResourceDownload(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public boolean matches(String urlPath) {
        return this.urlParser.matches(urlPath);
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginAccessor = pluginManager;
    }

    public void serveFile(BaseFileServerServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String requestUri = servlet.urlDecode(httpServletRequest.getRequestURI());
        PluginResource resource = this.urlParser.parse(requestUri);
        if (resource != null) {
            this.servePluginResource(servlet, httpServletRequest, httpServletResponse, resource.getModuleCompleteKey(), resource.getResourceName());
        } else {
            log.info((Object)("Invalid resource path spec: " + httpServletRequest.getRequestURI()));
            httpServletResponse.sendError(404);
        }
    }

    protected void servePluginResource(BaseFileServerServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String moduleCompleteKey, String resourceName) throws IOException {
        DownloadableResource resource = null;
        if (moduleCompleteKey.indexOf(":") > -1) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getPluginModule(moduleCompleteKey);
            if (moduleDescriptor != null && this.pluginAccessor.isPluginModuleEnabled(moduleCompleteKey)) {
                resource = this.getResourceFromModule(moduleDescriptor, resourceName, servlet);
            } else {
                log.info((Object)("Module not found: " + moduleCompleteKey));
                httpServletResponse.sendError(404);
            }
        } else {
            Plugin plugin = this.pluginAccessor.getPlugin(moduleCompleteKey);
            resource = this.getResourceFromPlugin(plugin, resourceName, "", servlet);
        }
        if (resource == null) {
            resource = this.getResourceFromPlugin(moduleCompleteKey, resourceName, servlet);
        }
        if (resource != null) {
            resource.serveResource(httpServletRequest, httpServletResponse);
        } else {
            log.info((Object)("Unable to find resource for plugin: " + moduleCompleteKey + " and path: " + resourceName));
        }
    }

    private DownloadableResource getResourceFromPlugin(String moduleKey, String resourcePath, BaseFileServerServlet servlet) {
        if (moduleKey.indexOf(58) < 0 || moduleKey.indexOf(58) == moduleKey.length() - 1) {
            return null;
        }
        Plugin plugin = this.pluginAccessor.getPlugin(moduleKey.substring(0, moduleKey.indexOf(58)));
        if (plugin == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, resourcePath, "", servlet);
    }

    private DownloadableResource getResourceFromPlugin(Plugin plugin, String resourcePath, String filePath, BaseFileServerServlet servlet) {
        ResourceLocation resourceLocation = plugin.getResourceLocation(DOWNLOAD_RESOURCE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(servlet, plugin, resourceLocation, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, nextParts[0], nextParts[1] + filePath, servlet);
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor moduleDescriptor, String filePath, BaseFileServerServlet servlet) {
        return this.getResourceFromModule(moduleDescriptor, filePath, "", servlet);
    }

    DownloadableResource getResourceFromModule(ModuleDescriptor moduleDescriptor, String resourcePath, String filePath, BaseFileServerServlet servlet) {
        Plugin plugin = this.pluginAccessor.getPlugin(moduleDescriptor.getPluginKey());
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(DOWNLOAD_RESOURCE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(servlet, plugin, resourceLocation, filePath);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromModule(moduleDescriptor, nextParts[0], nextParts[1] + filePath, servlet);
    }

    private DownloadableResource getDownloadablePluginResource(BaseFileServerServlet servlet, Plugin plugin, ResourceLocation resourceLocation, String filePath) {
        if ("webContext".equalsIgnoreCase(resourceLocation.getParameter("source"))) {
            return new DownloadableWebResource(servlet, plugin, resourceLocation, filePath);
        }
        return new DownloadableClasspathResource(servlet, plugin, resourceLocation, filePath);
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }
}

