/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors.servlet;

import com.atlassian.plugin.descriptors.servlet.ServletModuleManager;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ServletModuleContainerServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog((Class)ServletModuleContainerServlet.class);
    private ServletConfig servletConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getServletModuleManager() == null) {
            log.error((Object)"Could not get ServletModuleManager?");
            response.sendError(500, "Could not get ServletModuleManager.");
            return;
        }
        HttpServlet servlet = this.getServletModuleManager().getServlet(request.getPathInfo(), this.servletConfig);
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.debug((Object)("No servlet found for: " + request.getRequestURI()));
        response.sendError(404, "Could not find servlet for: " + request.getRequestURI());
    }

    protected abstract ServletModuleManager getServletModuleManager();
}

