/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer.instance;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import io.atlassian.util.concurrent.Lazy;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativeUrlTransformerFactory
implements WebResourceTransformerFactory {
    @Deprecated
    public static final String RELATIVE_URL_QUERY_KEY = "relative-url";
    private static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\s*\\(\\s*+([\"'])?+(?!/|https?://|data:)");
    private final WebResourceIntegration webResourceIntegration;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final CdnResourceUrlTransformer cdnResourceUrlTransformer;
    private final boolean usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins;

    public RelativeUrlTransformerFactory(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, CdnResourceUrlTransformer cdnResourceUrlTransformer) {
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.cdnResourceUrlTransformer = cdnResourceUrlTransformer;
        this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins = webResourceIntegration.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins();
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new RelativeUrlTransformerUrlBuilder();
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return new RelativeUrlTransformer(parameters);
    }

    public Set<String> allUsedQueryParameters() {
        return Set.of(RELATIVE_URL_QUERY_KEY);
    }

    @VisibleForTesting
    static String removeComponentsBeforePath(String resourceCdnPrefix) {
        int hostnameStart = resourceCdnPrefix.indexOf("//") + 2;
        int pathStart = resourceCdnPrefix.indexOf("/", hostnameStart);
        if (pathStart == -1) {
            return "";
        }
        return resourceCdnPrefix.substring(pathStart);
    }

    class RelativeUrlTransformerUrlBuilder
    implements TransformerUrlBuilder {
        RelativeUrlTransformerUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            if (RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy() != null && RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy().supportsCdn()) {
                this.addRelativeUrlQueryKey(urlBuilder);
            }
        }

        private void addRelativeUrlQueryKey(UrlBuilder urlBuilder) {
            urlBuilder.addToQueryString(RelativeUrlTransformerFactory.RELATIVE_URL_QUERY_KEY, String.valueOf(true));
        }
    }

    class RelativeUrlTransformer
    implements UrlReadingWebResourceTransformer {
        private final TransformerParameters parameters;

        RelativeUrlTransformer(TransformerParameters parameters) {
            this.parameters = parameters;
        }

        public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
            boolean requestCdnUrl = Boolean.parseBoolean(params.get(RelativeUrlTransformerFactory.RELATIVE_URL_QUERY_KEY));
            Supplier<String> urlPrefix = this.createUrlPrefixRef(RelativeUrlTransformerFactory.this.cdnResourceUrlTransformer, requestCdnUrl);
            final Function<Matcher, CharSequence> replacer = matcher -> new StringBuilder(matcher.group()).append((String)urlPrefix.get());
            return new CharSequenceDownloadableResource(transformableResource.nextResource()){

                @Override
                protected CharSequence transform(CharSequence originalContent) {
                    Matcher matcher = CSS_URL_PATTERN.matcher(originalContent);
                    StringBuffer output = new StringBuffer();
                    while (matcher.find()) {
                        CharSequence sequence = (CharSequence)replacer.apply(matcher);
                        matcher.appendReplacement(output, "");
                        output.append(sequence);
                    }
                    matcher.appendTail(output);
                    return output;
                }
            };
        }

        private Supplier<String> createUrlPrefixRef(CdnResourceUrlTransformer cdnResourceUrlTransformer, boolean requestCdnUrl) {
            return Lazy.supplier(() -> {
                String version = Config.getPluginVersionOrInstallTime(RelativeUrlTransformerFactory.this.webResourceIntegration.getPluginAccessor().getPlugin(this.parameters.getPluginKey()), RelativeUrlTransformerFactory.this.usePluginInstallTimeInsteadOfTheVersionForSnapshotPlugins);
                String resourcePrefix = "/download/resources";
                String localRelativeUrl = RelativeUrlTransformerFactory.this.webResourceUrlProvider.getStaticResourcePrefix(version, UrlMode.RELATIVE) + resourcePrefix + "/" + this.parameters.getPluginKey() + ":" + this.parameters.getModuleKey() + "/";
                if (!requestCdnUrl) {
                    return localRelativeUrl;
                }
                CDNStrategy cdnStrategy = RelativeUrlTransformerFactory.this.webResourceIntegration.getCDNStrategy();
                if (cdnStrategy == null || !cdnStrategy.supportsCdn()) {
                    throw new CdnStrategyChangedException("CDN strategy has changed between url generation time and resource fetch time");
                }
                String resourceCdnPrefix = cdnResourceUrlTransformer.getResourceCdnPrefix(localRelativeUrl);
                return RelativeUrlTransformerFactory.removeComponentsBeforePath(resourceCdnPrefix);
            });
        }
    }

    public static class CdnStrategyChangedException
    extends RuntimeException {
        public CdnStrategyChangedException(String message) {
            super(message);
        }
    }
}

