/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.assembler.WebResourceInformation;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.SuperbatchConfiguration;
import com.atlassian.plugin.webresource.impl.helpers.ResourceGenerationInfo;
import com.atlassian.plugin.webresource.impl.helpers.data.ResourceDataGenerator;
import com.atlassian.plugin.webresource.impl.helpers.url.Resolved;
import com.atlassian.plugin.webresource.impl.helpers.url.ResourceUrlGenerator;
import com.atlassian.plugin.webresource.models.SuperBatchKey;
import com.atlassian.plugin.webresource.models.SyncBatchKey;
import com.atlassian.plugin.webresource.models.WebResourceKey;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.atlassian.webresource.api.data.PluginDataResource;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DefaultWebResourceSetBuilder {
    @VisibleForTesting
    static final WebResourceKey WEB_RESOURCE_MANAGER_RESOURCE = new WebResourceKey("com.atlassian.plugins.atlassian-plugins-webresource-rest:web-resource-manager");
    @VisibleForTesting
    static final WebResourceKey DATA_COLLECTOR_OBSERVER_RESOURCE = new WebResourceKey("com.atlassian.plugins.atlassian-plugins-webresource-rest:data-collector-perf-observer");
    @VisibleForTesting
    static final WebResourceKey DATA_COLLECTOR_ASYNC_RESOURCE = new WebResourceKey("com.atlassian.plugins.atlassian-plugins-webresource-rest:data-collector-async");
    private final RequestState requestState;
    private boolean cleanUpAfterInclude;
    private boolean addWebResourceJavascriptApiDependencies;
    private boolean isSuperbatchEnabled = false;

    public DefaultWebResourceSetBuilder(@Nonnull RequestState requestState) {
        this.requestState = Objects.requireNonNull(requestState, "The request state is mandatory for building the DefaultWebResourceSetBuilder.");
        this.cleanUpAfterInclude = false;
        this.addWebResourceJavascriptApiDependencies = true;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder disableCleanUpAfterInclude() {
        this.cleanUpAfterInclude = false;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder enableCleanUpAfterInclude() {
        this.cleanUpAfterInclude = true;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder disableAdditionOfWebResourceJavascriptApiDependencies() {
        this.addWebResourceJavascriptApiDependencies = false;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder enableAdditionOfWebResourceJavascriptApiDependencies() {
        this.addWebResourceJavascriptApiDependencies = true;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder enableSuperbatch() {
        this.isSuperbatchEnabled = true;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSetBuilder disableSuperbatch() {
        this.isSuperbatchEnabled = false;
        return this;
    }

    @Nonnull
    public DefaultWebResourceSet build() {
        SuperbatchConfiguration superbatchConfiguration = this.requestState.getSuperbatchConfiguration();
        if (this.isSuperbatchEnabled && superbatchConfiguration.isEnabled()) {
            this.requestState.getRawRequest().includeFirst(superbatchConfiguration.getResourcePhase(), SuperBatchKey.getInstance());
        }
        if (this.requestState.isSyncbatchEnabled()) {
            this.requestState.getRawRequest().includeFirst(ResourcePhase.INLINE, SyncBatchKey.getInstance());
        }
        if (this.addWebResourceJavascriptApiDependencies && this.requestState.isAutoIncludeFrontendRuntimeEnabled()) {
            if (this.requestState.getGlobals().getConfig().isPerformanceTrackingEnabled()) {
                this.requestState.getRawRequest().include(ResourcePhase.INLINE, DATA_COLLECTOR_OBSERVER_RESOURCE);
                this.requestState.getRawRequest().include(ResourcePhase.INTERACTION, DATA_COLLECTOR_ASYNC_RESOURCE);
            }
            if (this.requestState.getRawRequest().hasAny(ResourcePhase.INTERACTION)) {
                this.requestState.getRawRequest().includeFirst(superbatchConfiguration.getResourcePhase(), WEB_RESOURCE_MANAGER_RESOURCE);
            }
        }
        Deque webResourceInformation = Stream.of(ResourcePhase.values()).map(this::buildDependenciesByPhase).collect(Collectors.toCollection(ArrayDeque::new));
        return new DefaultWebResourceSet(this.requestState.getGlobals().getConfig(), this.requestState, webResourceInformation);
    }

    private WebResourceInformation buildDependenciesByPhase(ResourcePhase resourcePhase) {
        ResourceGenerationInfo resourceGenerationInfo = new ResourceGenerationInfo(resourcePhase, this.requestState);
        Resolved resolved = new ResourceUrlGenerator(this.requestState.getGlobals().getUrlCache()).generate(resourceGenerationInfo);
        Set<PluginDataResource> pluginDataResources = new ResourceDataGenerator().generate(resourceGenerationInfo);
        if (this.cleanUpAfterInclude) {
            this.requestState.clearIncludedAndUpdateExcluded(resourcePhase, resolved.getExcludedResolved());
        }
        return new WebResourceInformation(pluginDataResources, resourcePhase, resolved.getUrls());
    }
}

