/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.snapshot.resource.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.transformer.ContentTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.DefaultTransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.transformer.UrlReadingContentTransformer;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.TransformationDto;
import com.atlassian.webresource.spi.TransformerDto;
import com.atlassian.webresource.spi.transformer.TwoPhaseResourceTransformer;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final String type;
    private final Map<String, Element> transformerElements;
    private final Iterable<String> transformerKeys;
    private final Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);

    public WebResourceTransformation(TransformationDto transformationDto) {
        Objects.requireNonNull(transformationDto.extension);
        this.type = transformationDto.extension;
        this.extension = "." + this.type;
        ArrayList<String> keys = new ArrayList<String>();
        for (TransformerDto transformerDto : transformationDto.transformers) {
            keys.add(transformerDto.key);
        }
        this.transformerKeys = keys;
        this.transformerElements = Collections.emptyMap();
    }

    public WebResourceTransformation(Element element) {
        Preconditions.checkArgument((element.attributeValue("extension") != null ? 1 : 0) != 0, (Object)"extension");
        this.type = element.attributeValue("extension");
        this.extension = "." + this.type;
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
        this.transformerKeys = this.transformerElements.keySet();
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public boolean matches(String locationType) {
        return locationType.equals(this.type);
    }

    public void addTransformParameters(TransformerCache transformerCache, TransformerParameters transformerParameters, UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy) {
        for (String key : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null) continue;
            if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                UrlReadingWebResourceTransformerModuleDescriptor descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                urlBuildingStrategy.addToUrl(descriptor.getModule().makeUrlBuilder(transformerParameters), urlBuilder);
                continue;
            }
            if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                ContentTransformerModuleDescriptor descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                urlBuildingStrategy.addToUrl(descriptor.getModule().makeUrlBuilder(transformerParameters), urlBuilder);
                continue;
            }
            throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
        }
    }

    public Content transform(CdnResourceUrlTransformer cdnResourceUrlTransformer, TransformerCache transformerCache, Resource resource, Content content, ResourceLocation resourceLocation, QueryParams params, String sourceUrl) {
        Content lastContent = content;
        for (String transformerKey : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(transformerKey);
            if (descriptorAsObject != null) {
                if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                    ContentTransformerModuleDescriptor descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                    UrlReadingContentTransformer transformer = descriptor.getModule().makeResourceTransformer(resource.getParent().getTransformerParameters());
                    if (transformer instanceof TwoPhaseResourceTransformer) {
                        ((TwoPhaseResourceTransformer)transformer).loadTwoPhaseProperties(resourceLocation, resource::getStreamFor);
                    }
                    lastContent = transformer.transform(cdnResourceUrlTransformer, lastContent, resourceLocation, params, sourceUrl);
                    continue;
                }
                Element configElement = this.transformerElements.get(transformerKey);
                if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                    UrlReadingWebResourceTransformerModuleDescriptor descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                    DefaultTransformableResource transformableResource = new DefaultTransformableResource(resourceLocation, ResourceServingHelpers.asDownloadableResource(lastContent));
                    UrlReadingWebResourceTransformer transformer = descriptor.getModule().makeResourceTransformer(resource.getParent().getTransformerParameters());
                    if (transformer instanceof TwoPhaseResourceTransformer) {
                        ((TwoPhaseResourceTransformer)transformer).loadTwoPhaseProperties(resourceLocation, resource::getStreamFor);
                    }
                    lastContent = ResourceServingHelpers.asContent(transformer.transform((TransformableResource)transformableResource, params), null, true);
                    continue;
                }
                throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
            }
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)transformerKey, (Object)resourceLocation.getName());
        }
        return lastContent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.transformerKeys.toString() + " transformers";
    }

    public boolean addAllUsedQueryParameters(Set<String> paramKeys, TransformerCache transformerCache) {
        for (String key : this.transformerKeys) {
            Set<String> transformerParamKeys;
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null) continue;
            if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                UrlReadingWebResourceTransformerModuleDescriptor descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                transformerParamKeys = descriptor.getModule().allUsedQueryParameters();
            } else if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                ContentTransformerModuleDescriptor descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                transformerParamKeys = descriptor.getModule().allUsedQueryParameters();
            } else {
                throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
            }
            if (transformerParamKeys != null) {
                paramKeys.addAll(transformerParamKeys);
                continue;
            }
            return false;
        }
        return true;
    }
}

