/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.cdn.mapper;

import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.mapper.MappingParser;
import com.atlassian.plugin.webresource.cdn.mapper.MappingParserException;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.WebResourceMapper;
import com.atlassian.plugin.webresource.prebake.PrebakeConfig;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebResourceMapper
implements WebResourceMapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceMapper.class);
    private final MappingSet mappings;
    private final String ctCdnBaseUrl;
    private final String contextPath;
    private final WebResourceIntegration webResourceIntegration;

    public DefaultWebResourceMapper(@Nonnull WebResourceIntegration webResourceIntegration, @Nonnull MappingParser mappingParser, @Nonnull PrebakeConfig prebakeConfig, @Nonnull String globalStateHash, @Nonnull String ctCdnBaseUrl, @Nonnull String contextPath) throws MappingParserException, IOException {
        Preconditions.checkNotNull((Object)webResourceIntegration, (Object)"webResourceIntegration is null!");
        Preconditions.checkNotNull((Object)mappingParser, (Object)"mappingParser is null!");
        Preconditions.checkNotNull((Object)prebakeConfig, (Object)"prebakeConfig is null!");
        Preconditions.checkNotNull((Object)globalStateHash, (Object)"globalStateHash is null!");
        Preconditions.checkNotNull((Object)ctCdnBaseUrl, (Object)"ctCdnBaseUrl is null!");
        this.webResourceIntegration = webResourceIntegration;
        this.mappings = this.loadMappings(mappingParser, globalStateHash, prebakeConfig);
        this.ctCdnBaseUrl = ctCdnBaseUrl;
        this.contextPath = contextPath;
    }

    @Override
    @Nonnull
    public List<String> map(@Nonnull String resourceUrl) {
        if (!this.webResourceIntegration.isCtCdnMappingEnabled()) {
            return Collections.emptyList();
        }
        List<String> mappedResources = this.mappings.getMappedResources(this.removeContext(resourceUrl));
        if (!mappedResources.isEmpty()) {
            log.debug("Mapped resource {} to {}", (Object)resourceUrl, mappedResources);
        } else {
            log.debug("Cache miss for resource {}", (Object)resourceUrl);
        }
        return mappedResources.stream().map(this::joinBaseUrlSafely).collect(Collectors.toList());
    }

    private String removeContext(String resourceUrl) {
        return this.contextPath == null || this.contextPath.isEmpty() || !resourceUrl.startsWith(this.contextPath) ? resourceUrl : resourceUrl.substring(this.contextPath.length());
    }

    private String joinBaseUrlSafely(String resourcePath) {
        boolean baseUrlHasSlash = this.ctCdnBaseUrl.endsWith("/");
        boolean resourcePathHasSlash = resourcePath.startsWith("/");
        if (baseUrlHasSlash && resourcePathHasSlash) {
            return this.ctCdnBaseUrl.substring(0, this.ctCdnBaseUrl.length() - 1) + resourcePath;
        }
        if (!baseUrlHasSlash && !resourcePathHasSlash) {
            return this.ctCdnBaseUrl + "/" + resourcePath;
        }
        return this.ctCdnBaseUrl + resourcePath;
    }

    @Override
    @Nonnull
    public Optional<String> mapSingle(@Nonnull String resourceUrl) {
        return this.map(resourceUrl).stream().findFirst();
    }

    private MappingSet loadMappings(MappingParser mappingParser, String globalStateHash, PrebakeConfig prebakeConfig) throws MappingParserException, IOException {
        long startTime = System.nanoTime();
        try {
            MappingSet mappingSet;
            File f = prebakeConfig.getMappingLocation(globalStateHash);
            log.info("Loading pre-baked CT-CDN mappings from '{}' with hash '{}'", (Object)f, (Object)globalStateHash);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
            try {
                MappingSet mappings = mappingParser.parse(reader);
                if (mappings.size() == 0) {
                    log.warn("Mappings loaded but empty! No CT-CDN pre-baked resources will be applied but will fall back to product's CDN Strategy, if any.");
                } else {
                    log.info("Mappings loaded with {} entries.", (Object)mappings.size());
                }
                mappingSet = mappings;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    log.info("Mappings file not found. This is not an error but means pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.");
                    throw e;
                }
                catch (MappingParserException | IOException e) {
                    log.warn("Could not load mappings from pattern '{}' with hash '{}'. Pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.", new Object[]{prebakeConfig.getPattern(), globalStateHash, e});
                    throw e;
                }
                catch (RuntimeException e) {
                    log.warn("Unexpected exception while loading mappings from pattern '{}' with hash '{}'. Pre-baked CT-CDN is disabled but will fall back to product's CDN Strategy, if any.", new Object[]{prebakeConfig.getPattern(), globalStateHash, e});
                    throw e;
                }
            }
            reader.close();
            return mappingSet;
        }
        finally {
            log.debug("Duration -> {} ms", (Object)(System.nanoTime() - startTime));
        }
    }

    @Override
    @Nonnull
    public MappingSet mappings() {
        return this.mappings;
    }
}

