package com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.stream;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;

public class StreamStrategyFactory {
    static public String WEB_CONTEXT_STATIC = "webContextStatic";

    private final ServletContextFactory servletContextFactory;
    private final WebResourceIntegration webResourceIntegration;

    public StreamStrategyFactory(ServletContextFactory servletContextFactory, WebResourceIntegration webResourceIntegration) {
        this.servletContextFactory = servletContextFactory;
        this.webResourceIntegration = webResourceIntegration;
    }


    public StreamStrategy createStandardModuleStreamStrategy(Bundle parent, ResourceLocation resourceLocation) {
        String sourceParam = resourceLocation.getParameter(Config.SOURCE_PARAM_NAME);
        final boolean isWebContextStatic = WEB_CONTEXT_STATIC.equalsIgnoreCase(sourceParam);

        if (isWebContextStatic) {
            return new TomcatStreamStrategy(servletContextFactory);
        } else {
            if (isKeyWebResourceIdentifier(parent.getKey())) {
                return new WebResourceStreamStrategy(webResourceIntegration, parent);
            } else {
                return new PluginStreamStrategy(webResourceIntegration, parent);
            }
        }
    }

    protected boolean isKeyWebResourceIdentifier(String resourceKey) {
        return resourceKey.contains(":");
    }

    // TODO: ES Module seems unaccessible from tomcat context - is it intended behaviour!?
    public StreamStrategy createESModuleStreamStrategy(String pluginKey) {
        return new ESModuleStreamStrategy(webResourceIntegration, pluginKey);
    }
}
