/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.http;

import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.BaseHelpers;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.http.Controller;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.plugin.webresource.impl.support.http.BaseRouter;
import com.atlassian.plugin.webresource.impl.support.http.Request;
import com.atlassian.plugin.webresource.impl.support.http.Response;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Router
extends BaseRouter<Controller> {
    public Router(final Globals globals) {
        super(globals);
        this.addRoute("/resources/:completeKey/*resourceName.map", new BaseRouter.Handler(){

            public void apply(Controller controller, String escapedCompleteKey, String escapedResourceName) {
                controller.serveResourceSourceMap(Router.unescapeSlashes(escapedCompleteKey), Router.unescapeSlashes(escapedResourceName));
            }
        });
        this.addRoute("/resources/:completeKey/*resourceName", new BaseRouter.Handler(){

            public void apply(Controller controller, String escapedCompleteKey, String escapedResourceName) {
                controller.serveResource(Router.unescapeSlashes(escapedCompleteKey), Router.unescapeSlashes(escapedResourceName));
            }
        });
        this.addRoute("/sources/:completeKey/*resourceName", new BaseRouter.Handler(){

            public void apply(Controller controller, String escapedCompleteKey, String escapedResourceName) {
                controller.serveSource(Router.unescapeSlashes(escapedCompleteKey), Router.unescapeSlashes(escapedResourceName));
            }
        });
        this.addRoute("/contextbatch/:type/:encodedContexts/*batchPostfixOrResourceName.map", new BaseRouter.Handler(){

            public void apply(Controller controller, String type, String encodedContexts, String escapedBatchPostfixOrResourceName) {
                String batchPostfixOrResourceName = Router.unescapeSlashes(escapedBatchPostfixOrResourceName);
                Tuple<Collection<String>, LinkedHashSet<String>> includedAndExcludedWebResources = Router.decodeContextsAsWebResources(encodedContexts);
                if (batchPostfixOrResourceName.equals("batch." + type)) {
                    controller.serveBatchSourceMap(includedAndExcludedWebResources.getFirst(), includedAndExcludedWebResources.getLast(), type, true, false);
                } else {
                    controller.serveResourceRelativeToBatchSourceMap(includedAndExcludedWebResources.getFirst(), includedAndExcludedWebResources.getLast(), batchPostfixOrResourceName, true, false);
                }
            }
        });
        this.addRoute("/contextbatch/:type/:encodedContexts/*batchPostfixOrResourceName", new BaseRouter.Handler(){

            public void apply(Controller controller, String type, String encodedContexts, String escapedBatchPostfixOrResourceName) {
                String batchPostfixOrResourceName = Router.unescapeSlashes(escapedBatchPostfixOrResourceName);
                Tuple<Collection<String>, LinkedHashSet<String>> includedAndExcludedWebResources = Router.decodeContextsAsWebResources(encodedContexts);
                if (batchPostfixOrResourceName.equals("batch." + type)) {
                    controller.serveBatch(includedAndExcludedWebResources.getFirst(), includedAndExcludedWebResources.getLast(), type, true, false, true, true);
                } else {
                    controller.serveResourceRelativeToBatch(includedAndExcludedWebResources.getFirst(), includedAndExcludedWebResources.getLast(), batchPostfixOrResourceName, true, false);
                }
            }
        });
        this.addRoute("/batch/:completeKey/*batchPostfixOrResourceName.map", new BaseRouter.Handler(){

            public void apply(Controller controller, String escapedCompleteKey, String escapedBatchPostfixOrResourceName) {
                String completeKey = Router.unescapeSlashes(escapedCompleteKey);
                String batchPostfixOrResourceName = Router.unescapeSlashes(escapedBatchPostfixOrResourceName);
                List<String> included = Arrays.asList(completeKey);
                LinkedHashSet<String> excluded = new LinkedHashSet<String>();
                if (completeKey.equals(ResourceUtils.getBasename(batchPostfixOrResourceName))) {
                    controller.serveBatchSourceMap(included, excluded, ResourceUtils.getType(batchPostfixOrResourceName), false, true);
                } else {
                    controller.serveResourceRelativeToBatchSourceMap(included, excluded, batchPostfixOrResourceName, false, true);
                }
            }
        });
        this.addRoute("/batch/:completeKey/*batchPostfixOrResourceName", new BaseRouter.Handler(){

            public void apply(Request request, Response response, Controller controller, String[] arguments) {
                String completeKey = Router.unescapeSlashes(arguments[0]);
                String batchPostfixOrResourceName = Router.unescapeSlashes(arguments[1]);
                List<String> included = Arrays.asList(completeKey);
                LinkedHashSet<String> excluded = new LinkedHashSet<String>();
                String type = ResourceUtils.getType(batchPostfixOrResourceName);
                if (completeKey.equals(ResourceUtils.getBasename(batchPostfixOrResourceName))) {
                    controller.serveBatch(included, excluded, type, false, true, false);
                } else {
                    RequestCache requestCache = new RequestCache(globals);
                    List<Resource> resources = globals.getSnapshot().find().included(included).excluded(excluded, BaseHelpers.isConditionsSatisfied(requestCache, request.getParams())).deep(false).deepFilter(BaseHelpers.isConditionsSatisfied(requestCache, request.getParams())).resources(requestCache).filter(ResourceServingHelpers.shouldBeIncludedInBatch(type, request.getParams())).end();
                    if (!resources.isEmpty()) {
                        controller.serveBatch(included, excluded, type, false, true, false);
                    } else {
                        controller.serveResourceRelativeToBatch(included, excluded, batchPostfixOrResourceName, false, true);
                    }
                }
            }
        });
    }

    public String contextBatchUrl(String key, String type, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/contextbatch/:type/:key/batch.:type", type, key, type), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String contextBatchSourceMapUrl(String key, String type, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/contextbatch/:type/:key/batch.:type.map", type, key, type), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String resourceUrlRelativeToContextBatch(String key, String type, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/contextbatch/:type/:key/:resourceName", type, key, resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public static String resourceUrlAsStaticMethod(String completeKey, String resourceName, Map<String, String> params) {
        return Router.buildUrl(Router.interpolate("/resources/:completeKey/:resourceName", completeKey, resourceName), params);
    }

    public String resourceUrl(String completeKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/resources/:completeKey/:resourceName", Router.escapeSlashes(completeKey), resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String resourceSourceMapUrl(String completeKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/resources/:completeKey/:resourceName.map", Router.escapeSlashes(completeKey), resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String pluginResourceUrl(String pluginKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/resources/:pluginKey/:resourceName", pluginKey, resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String resourceUrlWithoutHash(Resource resource, Map<String, String> params) {
        return Router.buildUrl(this.globals.getConfig().getBaseUrl() + Router.interpolate("/resources/:completeKey/:resourceName", resource.getKey(), resource.getName()), params);
    }

    public String sourceUrl(String completeKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return Router.buildUrl(this.globals.getConfig().getBaseUrl() + Router.interpolate("/sources/:completeKey/:resourceName", Router.escapeSlashes(completeKey), resourceName), params);
    }

    public String prebuildSourceUrl(String completeKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.sourceUrl(completeKey, Resource.getPrebuiltSourcePath(resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String sourceUrl(Resource resource) {
        return this.sourceUrl(resource.getKey(), resource.getName(), new HashMap<String, String>(), true, true, "", resource.getVersion());
    }

    public String prebuildSourceUrl(Resource resource) {
        return this.prebuildSourceUrl(resource.getKey(), resource.getName(), new HashMap<String, String>(), true, true, "", resource.getVersion());
    }

    public String webResourceBatchUrl(String completeKey, String type, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        String encodedCompleteKey = Router.escapeSlashes(completeKey);
        return this.buildUrlWithPrefix(Router.interpolate("/batch/:completeKey/:completeKey.:type", encodedCompleteKey, encodedCompleteKey, type), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String resourceUrlRelativeToWebResourceBatch(String completeKey, String resourceName, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String resourceHash, String resourceVersion) {
        return this.buildUrlWithPrefix(Router.interpolate("/batch/:completeKey/:resourceName", Router.escapeSlashes(completeKey), resourceName), params, isResourceSupportCache, isResourceSupportCdn, resourceHash, resourceVersion);
    }

    public String sourceMapUrl(String resourceUrl, Map<String, String> generatedParams) {
        return Router.buildUrl(resourceUrl + ".map", generatedParams);
    }

    protected Router(Globals globals, List<BaseRouter.Route> routes, boolean useAbsoluteUrl) {
        super(globals, routes, useAbsoluteUrl);
    }

    public Router cloneWithNewUrlMode(boolean useAbsoluteUrl) {
        return new Router(this.globals, this.routes, useAbsoluteUrl);
    }

    public String buildUrlWithPrefix(String url, Map<String, String> params, boolean isResourceSupportCache, boolean isResourceSupportCdn, String hash, String version) {
        String urlWithParams = Router.buildUrl(url, params);
        Config config = this.globals.getConfig();
        if (isResourceSupportCache) {
            String hashWithCdnMark = hash + (isResourceSupportCdn ? "-CDN" : "-T");
            if (isResourceSupportCdn && config.isCdnEnabled()) {
                String prefix = config.getResourceUrlPrefix(hashWithCdnMark, version, false);
                return config.getResourceCdnPrefix(prefix + urlWithParams);
            }
            String prefix = config.getResourceUrlPrefix(hashWithCdnMark, version, this.useAbsoluteUrl);
            return prefix + urlWithParams;
        }
        return config.getBaseUrl(this.useAbsoluteUrl) + urlWithParams;
    }

    public static String encodeContexts(Collection<String> includedContexts, Iterable<String> excludedContexts) {
        Iterable<String> excludedContextsList;
        Collection<String> includedContextsList;
        if (Config.isStaticContextOrderEnabled()) {
            includedContextsList = Router.sortContextList(includedContexts);
            excludedContextsList = Router.sortContextList(excludedContexts);
        } else {
            includedContextsList = includedContexts;
            excludedContextsList = excludedContexts;
        }
        String prefix = "_context:";
        StringBuilder buff = new StringBuilder();
        for (String context : includedContextsList) {
            buff.append(context.replace(prefix, "")).append(",");
        }
        for (String context : excludedContextsList) {
            buff.append("-").append(context.replace(prefix, "")).append(",");
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    private static List<String> sortContextList(Iterable<String> contexts) {
        ArrayList contextList = Lists.newArrayList(contexts);
        Collections.sort(contextList);
        return contextList;
    }

    public static Tuple<Collection<String>, Collection<String>> decodeContexts(String encodedContexts) {
        String[] tokens;
        ArrayList<String> includedContexts = new ArrayList<String>();
        ArrayList<String> excludedContexts = new ArrayList<String>();
        for (String token : tokens = encodedContexts.split(",")) {
            if (token.startsWith("-")) {
                excludedContexts.add(token.substring(1));
                continue;
            }
            includedContexts.add(token);
        }
        return new Tuple<Collection<String>, Collection<String>>(includedContexts, excludedContexts);
    }

    public static Tuple<Collection<String>, LinkedHashSet<String>> decodeContextsAsWebResources(String encodedContexts) {
        Tuple<Collection<String>, Collection<String>> includedAndExcludedContexts = Router.decodeContexts(encodedContexts);
        return new Tuple<Collection<String>, LinkedHashSet<String>>(Router.turnContextsIntoVirtualResources(includedAndExcludedContexts.getFirst()), new LinkedHashSet<String>(Router.turnContextsIntoVirtualResources(includedAndExcludedContexts.getLast())));
    }

    protected static Collection<String> turnContextsIntoVirtualResources(Collection<String> contexts) {
        ArrayList<String> virtualContextResources = new ArrayList<String>();
        for (String context : contexts) {
            virtualContextResources.add("_context:" + context);
        }
        return virtualContextResources;
    }

    @Override
    protected Controller createController(Globals globals, Request request, Response response) {
        return new Controller(globals, request, response);
    }

    public static boolean isSourceMap(Request request) {
        return "map".equals(request.getType());
    }

    public static String sourceMapUrlToUrl(String sourceMapUrl) {
        return sourceMapUrl.replaceAll("\\.map$", "").replaceAll("\\.map\\?", "?");
    }

    public static String escapeSlashes(String string) {
        return string.replaceAll("/", "::");
    }

    public static String unescapeSlashes(String string) {
        return string.replaceAll("::", "/");
    }
}

