/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.http;

import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.cache.filecache.impl.PassThroughCache;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugin.webresource.event.InvalidResourceCounterHashEvent;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.BaseHelpers;
import com.atlassian.plugin.webresource.impl.helpers.Helpers;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.impl.http.Router;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.plugin.webresource.impl.support.LineCountingProxyOutputStream;
import com.atlassian.plugin.webresource.impl.support.NullOutputStream;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.plugin.webresource.impl.support.http.BaseController;
import com.atlassian.plugin.webresource.impl.support.http.Request;
import com.atlassian.plugin.webresource.impl.support.http.Response;
import com.atlassian.plugin.webresource.legacy.LegacyUrlGenerationHelpers;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private final RequestCache requestCache;
    public static final String APPLICATION_JSON = "application/json";

    public Controller(Globals globals, Request request, Response response) {
        super(globals, request, response);
        this.requestCache = new RequestCache(globals);
    }

    public void serveResource(String completeKey, String resourceName) {
        LinkedHashSet<String> requiredResources = new LinkedHashSet<String>();
        requiredResources.add(completeKey);
        this.serveResource(requiredResources, ResourceServingHelpers.getResource(this.requestCache, completeKey, resourceName), true, false);
    }

    public void serveResourceSourceMap(String completeKey, String resourceName) {
        LinkedHashSet<String> requiredResources = new LinkedHashSet<String>();
        requiredResources.add(completeKey);
        this.serveSourceMap(requiredResources, ResourceServingHelpers.getResource(this.requestCache, completeKey, resourceName), false);
    }

    public void serveBatch(Collection<String> included, LinkedHashSet<String> excluded, String type, boolean resolveDependencies, boolean withLegacyConditions, boolean isCachingEnabled) {
        this.serveBatch(included, excluded, type, resolveDependencies, withLegacyConditions, isCachingEnabled, false);
    }

    public void serveBatch(Collection<String> included, LinkedHashSet<String> excluded, String type, boolean resolveDependencies, boolean withLegacyConditions, boolean isCachingEnabled, boolean verifyResourceCounterHash) {
        this.serveResources(new LinkedHashSet<String>(included), (Supplier<Collection<Resource>>)((Supplier)() -> {
            if (verifyResourceCounterHash && Config.isResourceCounterHashValidationEnabled() && !this.isResourceCounterHashValid(included, excluded)) {
                this.globals.getPluginEventManager().broadcast((Object)new InvalidResourceCounterHashEvent());
                return Collections.emptyList();
            }
            return this.getBatchResources(included, excluded, type, resolveDependencies, withLegacyConditions);
        }), isCachingEnabled);
    }

    private boolean isResourceCounterHashValid(Collection<String> included, LinkedHashSet<String> excluded) {
        String staticHashParam = this.request.getParams().get("_statichash");
        if (staticHashParam == null) {
            return true;
        }
        String urlHash = staticHashParam.substring(staticHashParam.lastIndexOf("/") + 1);
        LegacyUrlGenerationHelpers.Resolved resolved = LegacyUrlGenerationHelpers.calculateBatches(this.requestCache, UrlBuildingStrategy.normal(), new LinkedHashSet<String>(included), excluded, false);
        Tuple<List<UrlGenerationHelpers.ContextBatch>, List<UrlGenerationHelpers.WebResourceBatch>> contextBatches = UrlGenerationHelpers.splitIntoSubBatches(this.requestCache, UrlBuildingStrategy.normal(), resolved.contextBatchKeys, resolved.webResourceBatchKeys);
        return contextBatches.getFirst().stream().map(contextBatch -> contextBatch.subBatches.stream().map(subBatch -> {
            HashBuilder hashBuilder = new HashBuilder();
            subBatch.bundles.forEach(bundle -> {
                hashBuilder.add(bundle.getKey());
                hashBuilder.add(bundle.getVersion());
            });
            return hashBuilder.build();
        }).collect(Collectors.toList())).flatMap(Collection::stream).anyMatch(urlHash::equals);
    }

    public void serveBatchSourceMap(final Collection<String> included, final LinkedHashSet<String> excluded, final String type, final boolean resolveDependencies, final boolean withLegacyConditions) {
        this.serveResourcesSourceMap(new LinkedHashSet<String>(included), new Supplier<Collection<Resource>>(){

            public Collection<Resource> get() {
                return Controller.this.getBatchResources(included, excluded, type, resolveDependencies, withLegacyConditions);
            }
        });
    }

    protected List<Resource> getBatchResources(Collection<String> included, LinkedHashSet<String> excluded, String type, boolean resolveDependencies, boolean withLegacyConditions) {
        LinkedHashSet<String> excludedAndSync = new LinkedHashSet<String>(excluded);
        Bundle syncContext = this.requestCache.getSnapshot().get("_context:_sync");
        if (null != syncContext) {
            excludedAndSync.addAll(syncContext.getDependencies());
        }
        return this.requestCache.getSnapshot().find().included(included).excluded(excludedAndSync, BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deep(resolveDependencies).deepFilter(BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deepFilter((Predicate<Bundle>)(withLegacyConditions ? Predicates.alwaysTrue() : Predicates.not(BaseHelpers.hasLegacyCondition()))).resources(this.requestCache).filter(ResourceServingHelpers.shouldBeIncludedInBatch(type, this.request.getParams())).end();
    }

    public void serveResourceRelativeToBatch(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        this.serveResource(new LinkedHashSet<String>(included), this.getResourceRelativeToBatch(included, excluded, resourceName, resolveDependencies, withLegacyConditions), true, false);
    }

    public void serveResourceRelativeToBatchSourceMap(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        this.serveSourceMap(new LinkedHashSet<String>(included), this.getResourceRelativeToBatch(included, excluded, resourceName, resolveDependencies, withLegacyConditions), false);
    }

    protected Resource getResourceRelativeToBatch(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        List<String> bundles = this.requestCache.getSnapshot().find().included(included).excluded(excluded, BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deep(resolveDependencies).deepFilter(BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deepFilter((Predicate<Bundle>)(withLegacyConditions ? Predicates.alwaysTrue() : Predicates.not(BaseHelpers.hasLegacyCondition()))).end();
        return ResourceServingHelpers.getResource(this.requestCache, bundles, resourceName);
    }

    public void serveSource(String completeKey, String resourceName) {
        Resource resource;
        if (Resource.isPrebuiltSourceName(resourceName)) {
            resourceName = Resource.getResourceNameFromPrebuiltSourceName(resourceName);
        }
        if (this.handleNotFoundRedirectAndNotModified(resource = ResourceServingHelpers.getResource(this.requestCache, completeKey, resourceName))) {
            return;
        }
        this.sendCached(new ContentImpl(resource.getContentType(), false){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                String prebuildSourceName = Resource.getPrebuiltSourcePath(resource.getLocation());
                InputStream sourceStream = resource.getStreamFor(prebuildSourceName);
                if (sourceStream != null) {
                    Support.copy(sourceStream, out);
                } else {
                    resource.getContent().writeTo(out, isSourceMapEnabled);
                }
                return null;
            }
        }, resource.getParams(), false);
    }

    protected void serveResource(LinkedHashSet<String> requiredResources, Resource resource, boolean applyTransformations, boolean isCachingEnabled) {
        if (log.isDebugEnabled() && Objects.nonNull(resource)) {
            log.debug("Serving requiredResources {} resource with name {}", (Object)String.join((CharSequence)"|", requiredResources), (Object)resource.getFullName());
        }
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            if (log.isDebugEnabled() && Objects.nonNull(resource)) {
                log.debug("Resource {} has already been handled according to handleNotFoundRedirectAndNotModified, returning", (Object)resource.getFullName());
            }
            return;
        }
        Content content = applyTransformations ? Helpers.transform(this.globals, requiredResources, this.request.getUrl(), resource, this.request.getParams(), true) : resource.getContent();
        this.sendCached(content, resource.getParams(), isCachingEnabled);
    }

    protected void serveResources(LinkedHashSet<String> requiredResources, Supplier<Collection<Resource>> resources, boolean isCachingEnabled) {
        if (log.isDebugEnabled()) {
            log.debug("Serving requiredResources {} and resources with names {}", (Object)String.join((CharSequence)"|", requiredResources), (Object)((Collection)resources.get()).stream().map(Resource::getFullName).collect(Collectors.joining("|")));
        }
        String type = this.request.getType();
        Content content = Helpers.transform(this.globals, requiredResources, this.request.getUrl(), type, resources, this.request.getParams());
        this.sendCached(content, Collections.emptyMap(), isCachingEnabled);
    }

    protected void serveSourceMap(LinkedHashSet<String> requiredResources, Resource resource, boolean isCachingEnabled) {
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            return;
        }
        Content content = Helpers.transform(this.globals, requiredResources, Router.sourceMapUrlToUrl(this.request.getUrl()), resource, this.request.getParams(), true);
        this.sendCached(content, resource.getParams(), isCachingEnabled);
    }

    private void serveResourcesSourceMap(LinkedHashSet<String> requiredResources, Supplier<Collection<Resource>> resources) {
        String resourcePath = Router.sourceMapUrlToUrl(this.request.getPath());
        String type = Request.getType(resourcePath);
        Content content = Helpers.transform(this.globals, requiredResources, Router.sourceMapUrlToUrl(this.request.getUrl()), type, resources, this.request.getParams());
        this.sendCached(content, Collections.emptyMap(), true);
    }

    protected boolean handleNotFoundRedirectAndNotModified(Resource resource) {
        if (resource == null) {
            this.response.sendError(404);
            return true;
        }
        if (this.checkIfCachedAndNotModified(resource.getParent().getUpdatedAt())) {
            return true;
        }
        if (resource.isRedirect()) {
            this.response.sendRedirect(resource.getLocation(), resource.getContentType());
            return true;
        }
        return false;
    }

    protected boolean checkIfCachedAndNotModified(Date updatedAt) {
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(updatedAt);
        return this.request.isCacheable() && lastModifiedHandler.checkRequest(this.request.getOriginalRequest(), this.response.getOriginalResponse());
    }

    protected void sendCached(Content content, Map<String, String> params, boolean isCachingEnabled) {
        if (!content.isPresent()) {
            this.response.sendError(404);
            return;
        }
        if (Boolean.TRUE.toString().equals(params.get("allow-public-use"))) {
            this.response.getOriginalResponse().addHeader("Access-Control-Allow-Origin", "*");
        }
        if (this.isSourceMapEnabled() && content.isTransformed() && this.globals.getConfig().optimiseSourceMapsForDevelopment()) {
            this.sendCachedInDevelopment(content, isCachingEnabled);
        } else {
            this.sendCachedInProduction(content, isCachingEnabled);
        }
        log.debug("Called sendCached on the resource with request URL {} and response status code {}", (Object)this.request.getPath(), (Object)this.response.getOriginalResponse().getStatus());
    }

    protected void sendCachedInProduction(final Content content, boolean isCachingEnabled) {
        String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
        this.response.setContentTypeIfNotBlank(contentType);
        PassThroughCache cache = isCachingEnabled && this.request.isCacheable() ? this.globals.getContentCache() : new PassThroughCache();
        String cacheKey = this.buildCacheKey(this.request.getUrl());
        if (Router.isSourceMap(this.request)) {
            if (this.globals.getConfig().isSourceMapEnabled()) {
                cache.cache("http", cacheKey, this.response.getOutputStream(), new Cache.StreamProvider(){

                    @Override
                    public void write(OutputStream producerOut) {
                        LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(new NullOutputStream());
                        SourceMap sourceMap = content.writeTo(lineCountingStream, true);
                        if (sourceMap == null) {
                            String resourceUrl = Router.sourceMapUrlToUrl(Controller.this.request.getUrl());
                            sourceMap = Util.create1to1SourceMap((int)lineCountingStream.getLinesCount(), (String)resourceUrl);
                        }
                        try {
                            producerOut.write(sourceMap.generate().getBytes());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                this.response.sendError(503);
            }
        } else {
            cache.cache("http", cacheKey, this.response.getOutputStream(), producerOut -> content.writeTo(producerOut, false));
            if (this.isSourceMapEnabled() && content.isTransformed()) {
                String sourceMapUrl = this.globals.getRouter().sourceMapUrl(this.request.getPath(), this.request.getParams());
                try {
                    this.response.getOutputStream().write(("\n" + Util.generateSourceMapComment((String)sourceMapUrl, (String)contentType)).getBytes());
                }
                catch (IOException | RuntimeException e) {
                    Support.LOGGER.error("can't generate source map comment", (Throwable)e);
                }
            }
        }
    }

    protected void sendCachedInDevelopment(final Content content, boolean isCachingEnabled) {
        String cacheKey;
        String resourceContentType;
        PassThroughCache cache;
        String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
        this.response.setContentTypeIfNotBlank(contentType);
        Cache cache2 = cache = isCachingEnabled && this.request.isCacheable() ? this.globals.getContentCache() : new PassThroughCache();
        if (Router.isSourceMap(this.request)) {
            String resourcePath = Router.sourceMapUrlToUrl(this.request.getPath());
            resourceContentType = content.getContentType() != null ? content.getContentType() : this.globals.getConfig().getContentType(resourcePath);
            cacheKey = this.buildCacheKey(Router.sourceMapUrlToUrl(this.request.getUrl()));
        } else {
            resourceContentType = contentType;
            cacheKey = this.buildCacheKey(this.request.getUrl());
        }
        Cache.TwoStreamProvider twoStreamProvider = new Cache.TwoStreamProvider(){

            @Override
            public void write(OutputStream out1, OutputStream out2) {
                LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(out1);
                SourceMap sourceMap = content.writeTo(lineCountingStream, true);
                String sourceMapUrl = Controller.this.globals.getRouter().sourceMapUrl(Controller.this.request.getPath(), Controller.this.request.getParams());
                try {
                    out1.write(("\n" + Util.generateSourceMapComment((String)sourceMapUrl, (String)resourceContentType)).getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (sourceMap == null) {
                    String resourceUrl = Router.sourceMapUrlToUrl(Controller.this.request.getUrl());
                    sourceMap = Util.create1to1SourceMap((int)lineCountingStream.getLinesCount(), (String)resourceUrl);
                }
                try {
                    out2.write(sourceMap.generate().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        OutputStream out = this.response.getOutputStream();
        if (Router.isSourceMap(this.request)) {
            cache.cacheTwo("http", cacheKey, null, out, twoStreamProvider);
        } else {
            cache.cacheTwo("http", cacheKey, out, null, twoStreamProvider);
        }
    }

    protected String buildCacheKey(String url) {
        return url + "&_isMinificationEnabled=" + this.globals.getConfig().isMinificationEnabled();
    }

    protected boolean isSourceMapEnabled() {
        String resourcePath = "map".equals(this.request.getType()) ? Router.sourceMapUrlToUrl(this.request.getPath()) : this.request.getPath();
        String type = Request.getType(resourcePath);
        return this.globals.getConfig().isSourceMapEnabledFor(type);
    }
}

