/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.WebModule;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ModuleResource
extends Resource {
    private static final Map<String, String> DEFAULT_CONTENT_TYPES = ImmutableMap.builder().put((Object)"js", (Object)"application/javascript").put((Object)"css", (Object)"text/css").put((Object)"svg", (Object)"image/svg+xml").put((Object)"svgz", (Object)"image/svg+xml").put((Object)"ttf", (Object)"application/x-font-truetype").put((Object)"woff", (Object)"application/font-woff").put((Object)"woff2", (Object)"application/font-woff").put((Object)"otf", (Object)"application/x-font-opentype").put((Object)"eot", (Object)"application/vnd.ms-fontobject").build();
    private final String pluginKey;
    private final String type;

    public ModuleResource(WebModule parent, String pluginKey, String filePath, String type) {
        super(parent, new ResourceLocation(filePath, filePath, type, null, null, new HashMap()), type, type);
        this.type = type;
        this.pluginKey = pluginKey;
    }

    @Override
    public String getContentType() {
        switch (this.type) {
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
        }
        String fromResource = super.getContentType();
        return StringUtils.isBlank((CharSequence)fromResource) ? DEFAULT_CONTENT_TYPES.getOrDefault(this.type, fromResource) : fromResource;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }
}

