/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.modules;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingConditionElementParser;
import java.util.List;
import org.dom4j.Element;

public class ModulesDescriptor
extends AbstractModuleDescriptor<Void> {
    private final HostContainer hostContainer;
    private String dir;
    private UrlReadingConditionElementParser conditionElementParser;
    private List<WebResourceTransformation> transformations;
    private DecoratingCondition condition;
    private Element element;

    public ModulesDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer) {
        super(moduleFactory);
        this.hostContainer = hostContainer;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        this.dir = element.attributeValue("dir");
        this.transformations = WebResourceModuleDescriptor.parseTransformations(element);
        this.conditionElementParser = new UrlReadingConditionElementParser(this.hostContainer);
    }

    public void enabled() {
        super.enabled();
        this.condition = WebResourceModuleDescriptor.parseCondition(this.conditionElementParser, this.plugin, this.element);
    }

    public void disabled() {
        super.disabled();
        this.condition = null;
    }

    public Void getModule() {
        throw new UnsupportedOperationException("there's no module for modules descriptor");
    }

    public String getDir() {
        return this.dir;
    }

    public List<WebResourceTransformation> getTransformations() {
        return this.transformations;
    }

    public DecoratingCondition getCondition() {
        return this.condition;
    }
}

