/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.helpers;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseHelpers {
    public static Predicate<Bundle> isConditionsSatisfied(final RequestCache requestCache, final Map<String, String> params) {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                CachedCondition condition = bundle.getCondition();
                return condition == null || condition.evaluateSafely(requestCache, params);
            }
        };
    }

    public static Predicate<Bundle> isConditionsSatisfied(final RequestCache requestCache, final UrlBuildingStrategy urlBuilderStrategy) {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                CachedCondition condition = bundle.getCondition();
                return condition == null || condition.evaluateSafely(requestCache, urlBuilderStrategy);
            }
        };
    }

    public static Predicate<Bundle> hasLegacyCondition() {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                return bundle.hasLegacyConditions();
            }
        };
    }

    public static Predicate<Bundle> hasConditions() {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                return bundle.getCondition() != null;
            }
        };
    }

    public static BundleFinder find(Snapshot snapshot) {
        return new BundleFinder(snapshot);
    }

    protected static Found find(Snapshot snapshot, Collection<String> included, Set<String> excluded, Predicate<Bundle> conditionsForExcluded, boolean resolveExcluded, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter) {
        if (included.isEmpty()) {
            return new Found(new ArrayList<String>(), new ArrayList<String>());
        }
        Set<String> excludedResolved = resolveExcluded ? new HashSet<String>(BaseHelpers.find((Snapshot)snapshot, excluded, new LinkedHashSet<String>(), conditionsForExcluded, (boolean)false, (Predicate<Bundle>)Predicates.alwaysTrue(), conditionsForExcluded, (Predicate<Bundle>)Predicates.alwaysTrue()).found) : excluded;
        LinkedHashSet<String> resolved = new LinkedHashSet<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String key : included) {
            BaseHelpers.findItChangesArguments(snapshot, key, excludedResolved, new LinkedHashSet<String>(), deep, deepFilter, shallowFilter, resolved, skipped);
        }
        return new Found(new ArrayList<String>(resolved), skipped);
    }

    protected static void findItChangesArguments(Snapshot snapshot, String key, Set<String> excluded, LinkedHashSet<String> stack, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter, LinkedHashSet<String> resolved, List<String> skipped) {
        if (resolved.contains(key)) {
            return;
        }
        if (excluded.contains(key)) {
            return;
        }
        if (stack.contains(key)) {
            Support.LOGGER.warn("cyclic plugin resource dependency has been detected with: {}, stack trace: {}", (Object)key, stack);
            return;
        }
        stack.add(key);
        Bundle bundle = snapshot.get(key);
        if (bundle != null) {
            if (deepFilter.apply((Object)bundle)) {
                if (deep.apply((Object)bundle)) {
                    List<String> bundleDependencies = bundle.getDependencies();
                    for (String dependencyKey : bundleDependencies) {
                        BaseHelpers.findItChangesArguments(snapshot, dependencyKey, excluded, stack, deep, deepFilter, shallowFilter, resolved, skipped);
                    }
                }
                if (shallowFilter.apply((Object)bundle)) {
                    resolved.add(key);
                } else {
                    skipped.add(key);
                }
            } else {
                skipped.add(key);
            }
        } else if (Config.isContextKey(key)) {
            BaseHelpers.findItChangesArguments(snapshot, Config.virtualContextKeyToWebResourceKey(key), excluded, stack, deep, deepFilter, shallowFilter, resolved, skipped);
        }
        stack.remove(key);
    }

    public static List<Resource> getResources(RequestCache requestCache, Collection<String> keys) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String key : keys) {
            Bundle bundle = requestCache.getSnapshot().get(key);
            if (bundle == null) continue;
            for (Resource resource : bundle.getResources(requestCache).values()) {
                resources.add(resource);
            }
        }
        return resources;
    }

    public static class Found {
        public final List<String> found;
        public final List<String> skipped;

        public Found(List<String> found, List<String> skipped) {
            this.found = found;
            this.skipped = skipped;
        }
    }

    public static class ResourceFinder {
        private final BundleFinder bundleFinder;
        private final RequestCache requestCache;
        private Predicate<Resource> filter;

        public ResourceFinder(BundleFinder bundleFinder, RequestCache requestCache) {
            this.bundleFinder = bundleFinder;
            this.requestCache = requestCache;
        }

        public ResourceFinder filter(Predicate<Resource> filter) {
            this.filter = filter;
            return this;
        }

        public List<Resource> end() {
            List<String> keys = this.bundleFinder.end();
            List<Resource> resources = BaseHelpers.getResources(this.requestCache, keys);
            ArrayList<Resource> filtered = new ArrayList<Resource>();
            for (Resource resource : resources) {
                if (!this.filter.apply((Object)resource)) continue;
                filtered.add(resource);
            }
            return filtered;
        }
    }

    public static class BundleFinder {
        private Snapshot snapshot;
        private Collection<String> included = new ArrayList<String>();
        private Set<String> excluded = new HashSet<String>();
        private Predicate<Bundle> conditionsForExcluded;
        private boolean resolveExcluded = true;
        private Predicate<Bundle> deep = Predicates.alwaysTrue();
        private List<Predicate<Bundle>> deepFilters = new ArrayList<Predicate<Bundle>>();
        private List<Predicate<Bundle>> shallowFilters = new ArrayList<Predicate<Bundle>>();

        public BundleFinder(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public BundleFinder included(Collection<String> included) {
            this.included = included;
            return this;
        }

        public BundleFinder included(String key) {
            this.included = new ArrayList<String>();
            this.included.add(key);
            return this;
        }

        public BundleFinder excluded(LinkedHashSet<String> excluded, Predicate<Bundle> conditionsForExcluded) {
            this.excluded = excluded;
            this.conditionsForExcluded = conditionsForExcluded;
            this.resolveExcluded = true;
            return this;
        }

        public BundleFinder excludedResolved(Set<String> excluded) {
            this.excluded = excluded;
            this.conditionsForExcluded = Predicates.alwaysTrue();
            this.resolveExcluded = false;
            return this;
        }

        public BundleFinder deep(boolean deep) {
            return this.deep((Predicate<Bundle>)(deep ? Predicates.alwaysTrue() : Predicates.alwaysFalse()));
        }

        public BundleFinder deep(Predicate<Bundle> deep) {
            this.deep = deep;
            return this;
        }

        public BundleFinder deepFilter(Predicate<Bundle> filter) {
            this.deepFilters.add(filter);
            return this;
        }

        public BundleFinder shallowFilter(Predicate<Bundle> filter) {
            this.shallowFilters.add(filter);
            return this;
        }

        public Found endAndGetResult() {
            Predicate<Bundle> conditionsForExcluded = this.conditionsForExcluded == null ? Predicates.alwaysTrue() : this.conditionsForExcluded;
            return BaseHelpers.find(this.snapshot, this.included, this.excluded, conditionsForExcluded, this.resolveExcluded, this.deep, Support.efficientAndPredicate(this.deepFilters), Support.efficientAndPredicate(this.shallowFilters));
        }

        public List<String> end() {
            return this.endAndGetResult().found;
        }

        public ResourceFinder resources(RequestCache requestCache) {
            return new ResourceFinder(this, requestCache);
        }
    }
}

