/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.annotators;

import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;

public class TryCatchJsResourceContentAnnotator
extends ResourceContentAnnotator {
    private static final byte[] BEFORE_CHUNK = "try {\n".getBytes();
    private static final byte[] AFTER_CHUNK = "\n}catch(e){WRMCB(e)}".getBytes();
    public static final String CATCH_BLOCK = "WRMCB=function(e){var c=console;if(c&&c.log&&c.error){c.log('Error running batched script.');c.error(e);}}\n";

    @Override
    public int beforeResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException {
        if (!(resource instanceof ModuleResource)) {
            stream.write(BEFORE_CHUNK);
            return 1;
        }
        return 0;
    }

    @Override
    public void afterResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException {
        if (!(resource instanceof ModuleResource)) {
            stream.write(AFTER_CHUNK);
        }
    }

    @Override
    public int beforeAllResourcesInBatch(LinkedHashSet<String> requiredResources, String url, OutputStream stream) throws IOException {
        stream.write(CATCH_BLOCK.getBytes());
        return 1;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

