/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.cdn.mapper;

import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.cdn.mapper.WebResourceMapper;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MappedCDNStrategy
implements CDNStrategy {
    protected final Optional<CDNStrategy> cdnStrategy;
    protected final WebResourceMapper webResourceMapper;

    public MappedCDNStrategy(@Nonnull Optional<CDNStrategy> cdnStrategy, @Nonnull WebResourceMapper webResourceMapper) {
        Preconditions.checkNotNull(cdnStrategy, (Object)"cdnStrategy is null!");
        Preconditions.checkNotNull((Object)webResourceMapper, (Object)"webResourceMapper is null!");
        this.webResourceMapper = webResourceMapper;
        this.cdnStrategy = cdnStrategy;
    }

    @Override
    public boolean supportsCdn() {
        return this.cdnStrategy.map(CDNStrategy::supportsCdn).orElse(true);
    }

    @Override
    public String transformRelativeUrl(@Nonnull String url) {
        return this.webResourceMapper.map(url).stream().findFirst().orElseGet(() -> this.cdnStrategy.map(s -> s.transformRelativeUrl(url)).orElse(url));
    }
}

