/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssembler;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.util.TimeSpan;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class DefaultWebResourceAssemblerBuilder
implements PrebakeWebResourceAssemblerBuilder {
    private final Globals globals;
    private boolean isSuperBatchingEnabled;
    private Optional<TimeSpan> deadline = Optional.empty();
    private Optional<Coordinate> coord = Optional.empty();

    public DefaultWebResourceAssemblerBuilder(Globals globals) {
        this.globals = globals;
        this.isSuperBatchingEnabled = globals.getConfig().isSuperBatchingEnabled();
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder withCoordinate(Coordinate coord) {
        this.coord = Optional.of(coord);
        return this;
    }

    @Override
    public PrebakeWebResourceAssembler build() {
        UrlBuildingStrategy urlStrat = UrlBuildingStrategy.from(this.coord);
        RequestState requestState = new RequestState(this.globals, urlStrat);
        if (this.deadline.isPresent()) {
            requestState.setBigPipeDeadline(System.currentTimeMillis() + this.deadline.get().toMillis());
        }
        DefaultWebResourceAssembler assembler = new DefaultWebResourceAssembler(requestState, this.globals.getConfig());
        if (this.isSuperBatchingEnabled) {
            assembler.resources().requireContext("_super");
        }
        return assembler;
    }

    public WebResourceAssemblerBuilder includeSuperbatchResources(boolean include) {
        this.isSuperBatchingEnabled = include;
        return this;
    }

    public WebResourceAssemblerBuilder asyncDataDeadline(long deadline, TimeUnit timeunit) {
        this.deadline = Optional.of(new TimeSpan(deadline, timeunit));
        return this;
    }
}

