/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.helpers.Helpers;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.transformer.ContentTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingContentTransformer;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.DimensionAwareWebResourceTransformerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final String type;
    private final Map<String, Element> transformerElements;
    private final Iterable<String> transformerKeys;
    private Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);
    public static Map<String, String[]> TRANSFORMER_PARAMETERS = WebResourceTransformation.buildTransformerParameters();

    public static Map<String, String[]> buildTransformerParameters() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("com.atlassian.webresource.plugin.i18n.JsI18nTransformer", new String[]{"locale"});
        params.put("com.atlassian.plugins.less.LessWebResourceTransformerFactory", new String[0]);
        params.put("com.atlassian.soy.impl.webresource.SoyWebResourceTransformerFactory", new String[]{"locale"});
        return params;
    }

    public WebResourceTransformation(Element element) {
        Validate.notNull((Object)element.attribute("extension"));
        this.type = element.attributeValue("extension");
        this.extension = "." + this.type;
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
        this.transformerKeys = this.transformerElements.keySet();
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public boolean matches(String locationType) {
        return locationType.equals(this.type);
    }

    public void addTransformParameters(TransformerCache transformerCache, TransformerParameters transformerParameters, UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy) {
        for (String key : this.transformerKeys) {
            AbstractModuleDescriptor descriptor;
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null) continue;
            if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                urlBuildingStrategy.addToUrl(descriptor.getModule().makeUrlBuilder(transformerParameters), urlBuilder);
                continue;
            }
            if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                urlBuildingStrategy.addToUrl(descriptor.getModule().makeUrlBuilder(transformerParameters), urlBuilder);
                continue;
            }
            if (descriptorAsObject instanceof WebResourceTransformerModuleDescriptor) continue;
            throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
        }
    }

    public boolean containsOnlyPureUrlReadingTransformers(TransformerCache transformerCache) {
        for (String key : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null || !(descriptorAsObject instanceof WebResourceTransformerModuleDescriptor)) continue;
            return false;
        }
        return true;
    }

    public Iterable<WebResourceTransformerModuleDescriptor> getDeprecatedTransformers(TransformerCache transformerCache) {
        LinkedList<WebResourceTransformerModuleDescriptor> deprecatedTransformers = new LinkedList<WebResourceTransformerModuleDescriptor>();
        for (String key : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null || !(descriptorAsObject instanceof WebResourceTransformerModuleDescriptor)) continue;
            deprecatedTransformers.add((WebResourceTransformerModuleDescriptor)((Object)descriptorAsObject));
        }
        return deprecatedTransformers;
    }

    public Content transform(CdnResourceUrlTransformer cdnResourceUrlTransformer, TransformerCache transformerCache, Content content, ResourceLocation resourceLocation, String pluginKey, String filePath, String webResourceKey, QueryParams params, String sourceUrl) {
        Content lastContent = content;
        for (String transformerKey : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(transformerKey);
            if (descriptorAsObject != null) {
                AbstractModuleDescriptor descriptor;
                if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                    descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                    TransformerParameters transformerParameters = new TransformerParameters(pluginKey, webResourceKey);
                    UrlReadingContentTransformer transformer = descriptor.getModule().makeResourceTransformer(transformerParameters);
                    lastContent = transformer.transform(cdnResourceUrlTransformer, lastContent, resourceLocation, params, sourceUrl);
                    continue;
                }
                if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                    descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                    TransformableResource transformableResource = new TransformableResource(resourceLocation, filePath, Helpers.asDownloadableResource(lastContent));
                    TransformerParameters transformerParameters = new TransformerParameters(pluginKey, webResourceKey);
                    UrlReadingWebResourceTransformer transformer = descriptor.getModule().makeResourceTransformer(transformerParameters);
                    lastContent = Helpers.asContent(transformer.transform(transformableResource, params), null, true);
                    continue;
                }
                if (descriptorAsObject instanceof WebResourceTransformerModuleDescriptor) {
                    descriptor = (WebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                    lastContent = Helpers.asContent(descriptor.getModule().transform(this.transformerElements.get(transformerKey), resourceLocation, filePath, Helpers.asDownloadableResource(lastContent)), null, true);
                    continue;
                }
                throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
            }
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)transformerKey, (Object)resourceLocation.getName());
        }
        return lastContent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.transformerKeys.toString() + " transformers";
    }

    public Map<String, String> leaveOnlyUsedParameters(TransformerCache transformerCache, Map<String, String> params) {
        ArrayList<String> transformerClasses = new ArrayList<String>();
        for (String string : this.transformerKeys) {
            AbstractModuleDescriptor descriptor;
            Object descriptorObj = transformerCache.getDescriptor(string);
            if (descriptorObj instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorObj);
                transformerClasses.add(descriptor.getModule().getClass().getName());
                continue;
            }
            if (descriptorObj instanceof ContentTransformerModuleDescriptor) {
                descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorObj);
                transformerClasses.add(descriptor.getModule().getClass().getName());
                continue;
            }
            if (descriptorObj == null) continue;
            throw new RuntimeException("error, trying to determine used parameters for legacy transformer!");
        }
        HashSet usedKeys = new HashSet();
        for (String klass : transformerClasses) {
            String[] keys = TRANSFORMER_PARAMETERS.get(klass);
            if (keys == null) {
                return params;
            }
            Collections.addAll(usedKeys, keys);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String key : usedKeys) {
            if (!params.containsKey(key)) continue;
            hashMap.put(key, params.get(key));
        }
        return hashMap;
    }

    public Dimensions computeDimensions(TransformerCache transformerCache) {
        Dimensions d = Dimensions.empty();
        for (String key : this.transformerKeys) {
            UrlReadingWebResourceTransformerModuleDescriptor descriptor;
            WebResourceTransformerFactory module;
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (!(descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) || !((module = (descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject)).getModule()) instanceof DimensionAwareWebResourceTransformerFactory)) continue;
            d = d.product(((DimensionAwareWebResourceTransformerFactory)module).computeDimensions());
        }
        return d;
    }
}

