/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.webresource.spi.CompilerUtil;
import com.atlassian.webresource.spi.ResourceCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompileTimeTransformer {
    public static Content process(final Globals globals, final Resource resource, final Content content) {
        return new ContentImpl(content.getContentType(), true){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                Config config = globals.getConfig();
                boolean hasMinifiedVersion = false;
                String pathForMinifiedVersion = null;
                InputStream minifiedStream = null;
                if (CompileTimeTransformer.isMinificationEnabledFor(config, resource)) {
                    pathForMinifiedVersion = CompileTimeTransformer.getPathForMinifiedVersion(resource.getPath());
                    minifiedStream = null;
                    if (config.isGlobalMinificationEnabled() && resource.getNameOrLocationType().equals("js")) {
                        minifiedStream = CompilerUtil.toInputStream((ResourceCompiler)config.getResourceCompiler(), (String)resource.getPath());
                    }
                    if (minifiedStream == null) {
                        minifiedStream = resource.getStreamFor(pathForMinifiedVersion);
                    }
                    if (minifiedStream == null) {
                        pathForMinifiedVersion = CompileTimeTransformer.getAlternatePathForMinifiedVersion(resource.getPath());
                        minifiedStream = resource.getStreamFor(pathForMinifiedVersion);
                    }
                    boolean bl = hasMinifiedVersion = minifiedStream != null;
                }
                if (hasMinifiedVersion) {
                    Support.copy(minifiedStream, out);
                } else {
                    content.writeTo(out, isSourceMapEnabled);
                }
                if (isSourceMapEnabled) {
                    try {
                        boolean hasPrebuildSource;
                        String prebuildSourcePath = Resource.getPrebuiltSourcePath(resource.getLocation());
                        InputStream sourceStream = resource.getStreamFor(prebuildSourcePath);
                        boolean bl = hasPrebuildSource = sourceStream != null;
                        if (sourceStream != null) {
                            try {
                                sourceStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        String sourceUrl = hasPrebuildSource ? globals.getRouter().prebuildSourceUrl(resource) : globals.getRouter().sourceUrl(resource);
                        if (hasMinifiedVersion) {
                            return Support.getSourceMap(pathForMinifiedVersion, resource, sourceUrl);
                        }
                        return Support.getSourceMap(resource.getPath(), resource, sourceUrl);
                    }
                    catch (RuntimeException e) {
                        Support.LOGGER.warn("can't parse source map for " + resource.getKey() + "/" + resource.getName(), (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
        };
    }

    private static boolean isMinificationEnabledFor(Config config, Resource resource) {
        if (!resource.getParent().isMinificationEnabled()) {
            return false;
        }
        if (!config.isMinificationEnabled()) {
            return false;
        }
        String path = resource.getPath();
        if (path.endsWith(".js")) {
            return !path.endsWith("-min.js") && !path.endsWith(".min.js");
        }
        if (path.endsWith(".css")) {
            return !path.endsWith("-min.css") && !path.endsWith(".min.css");
        }
        return false;
    }

    private static String getPathForMinifiedVersion(String path) {
        int lastDot = path.lastIndexOf(".");
        return path.substring(0, lastDot) + "-min" + path.substring(lastDot);
    }

    private static String getAlternatePathForMinifiedVersion(String path) {
        int lastDot = path.lastIndexOf(".");
        return path.substring(0, lastDot) + ".min" + path.substring(lastDot);
    }
}

