/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.impl.snapshot.WebResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebModule
extends WebResource {
    private final String pluginKey;
    private final String filePath;
    private final LinkedHashMap<String, String> unresolvedDependencies;
    private final LinkedHashSet<String> webResourceDependencies;
    private final String type;
    private final String srcType;
    private final String baseName;
    private final String soyNamespace;

    public WebModule(Snapshot snapshot, String pluginKey, String key, String baseName, List<String> dependencies, LinkedHashMap<String, String> unresolvedDependencies, LinkedHashSet<String> webResourceDependencies, Date updatedAt, String version, TransformerParameters transformerParameters, String filePath, String type, String srcType, String soyNamespace, Map<String, Set<String>> locationResourceTypes) {
        super(snapshot, key, dependencies, updatedAt, version, true, transformerParameters, locationResourceTypes);
        this.baseName = baseName;
        this.pluginKey = pluginKey;
        this.filePath = filePath;
        this.type = type;
        this.srcType = srcType;
        this.soyNamespace = soyNamespace;
        this.unresolvedDependencies = unresolvedDependencies;
        this.webResourceDependencies = webResourceDependencies;
    }

    @Override
    public String getWebResourceKey() {
        return null;
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Override
    public LinkedHashMap<String, Resource> getResources(RequestCache cache) {
        Resource resource = this.getResource();
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<String, Resource>();
        resources.put(resource.getName(), resource);
        return resources;
    }

    public Resource getResource() {
        return new ModuleResource(this, this.pluginKey, this.filePath, this.type);
    }

    public LinkedHashMap<String, String> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    @Override
    public LinkedHashMap<String, Jsonable> getData() {
        return new LinkedHashMap<String, Jsonable>();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public String getSoyNamespace() {
        return this.soyNamespace;
    }
}

