/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.BaseHelpers;
import com.atlassian.plugin.webresource.impl.helpers.Helpers;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.impl.snapshot.WebResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class Snapshot {
    final Config config;
    private final Map<String, Bundle> cachedBundles;
    private final Map<String, RootPage> rootPages;
    final Map<WebResource, CachedTransformers> webResourcesTransformations;
    final Map<WebResource, CachedCondition> webResourcesCondition;
    final Set<WebResource> webResourcesWithLegacyConditions;
    final Set<WebResource> webResourcesWithLegacyTransformers;
    final Set<WebResource> webResourcesWithDisabledMinification;

    public Snapshot(Config config) {
        this(config, new HashMap<String, Bundle>(), new HashMap<String, RootPage>(), new HashMap<WebResource, CachedTransformers>(), new HashMap<WebResource, CachedCondition>(), new HashSet<WebResource>(), new HashSet<WebResource>(), new HashSet<WebResource>());
    }

    public Snapshot(Config config, Map<String, Bundle> cachedBundles, Map<String, RootPage> rootPages, Map<WebResource, CachedTransformers> webResourcesTransformations, Map<WebResource, CachedCondition> webResourcesCondition, Set<WebResource> webResourcesWithLegacyConditions, Set<WebResource> webResourcesWithLegacyTransformers, Set<WebResource> webResourcesWithDisabledMinification) {
        this.cachedBundles = cachedBundles;
        this.rootPages = rootPages;
        this.webResourcesTransformations = webResourcesTransformations;
        this.webResourcesCondition = webResourcesCondition;
        this.webResourcesWithLegacyConditions = webResourcesWithLegacyConditions;
        this.webResourcesWithLegacyTransformers = webResourcesWithLegacyTransformers;
        this.webResourcesWithDisabledMinification = webResourcesWithDisabledMinification;
        this.config = config;
    }

    public List<Bundle> toBundles(Iterable<String> keys) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (String key : keys) {
            Bundle bundle = this.get(key);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    public void forEachBundle(Consumer<Bundle> consumer) {
        this.cachedBundles.values().forEach(consumer);
    }

    public Bundle get(String key) {
        return this.cachedBundles.get(key);
    }

    public RootPage getRootPage(String key) {
        return this.rootPages.get(key);
    }

    public Iterable<RootPage> getAllRootPages() {
        return this.rootPages.values();
    }

    public Iterable<CachedCondition> conditions() {
        return this.webResourcesCondition.values();
    }

    public Iterable<CachedTransformers> transformers() {
        return this.webResourcesTransformations.values();
    }

    public BaseHelpers.BundleFinder find() {
        return Helpers.find(this);
    }

    public Set<WebResource> getWebResourcesWithLegacyConditions() {
        return this.webResourcesWithLegacyConditions;
    }

    public Set<WebResource> getWebResourcesWithLegacyTransformers() {
        return this.webResourcesWithLegacyTransformers;
    }
}

