/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssembler;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.util.TimeSpan;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class DefaultWebResourceAssemblerBuilder
implements PrebakeWebResourceAssemblerBuilder {
    private final Globals globals;
    private Optional<Boolean> isSuperBatchingEnabled = Optional.empty();
    private Optional<TimeSpan> deadline = Optional.empty();
    private Optional<Coordinate> coord = Optional.empty();

    public DefaultWebResourceAssemblerBuilder(Globals globals) {
        this.globals = globals;
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder withCoordinate(Coordinate coord) {
        this.coord = Optional.of(coord);
        return this;
    }

    @Override
    public PrebakeWebResourceAssembler build() {
        Config config = this.globals.getConfig();
        UrlBuildingStrategy urlStrat = UrlBuildingStrategy.from(this.coord);
        RequestState requestState = new RequestState(this.globals, urlStrat);
        DefaultWebResourceAssembler assembler = new DefaultWebResourceAssembler(requestState, this.globals);
        if (config.isSyncContextCreated()) {
            assembler.resources().requireContext("_sync");
            requestState.setSyncResourceSet((DefaultWebResourceSet)assembler.assembled().drainIncludedResources());
        }
        if (this.deadline.isPresent()) {
            requestState.setBigPipeDeadline(System.currentTimeMillis() + this.deadline.get().toMillis());
        }
        boolean includeSuperbatch = config.isSuperBatchingEnabled();
        if (this.isSuperBatchingEnabled.isPresent()) {
            includeSuperbatch = this.isSuperBatchingEnabled.get();
        }
        if (includeSuperbatch) {
            assembler.resources().requireContext("_super");
        }
        return assembler;
    }

    public WebResourceAssemblerBuilder includeSuperbatchResources(boolean include) {
        this.isSuperBatchingEnabled = Optional.of(include);
        return this;
    }

    public WebResourceAssemblerBuilder asyncDataDeadline(long deadline, TimeUnit timeunit) {
        this.deadline = Optional.of(new TimeSpan(deadline, timeunit));
        return this;
    }
}

