package com.atlassian.plugin.webresource.impl.helpers;

import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.sourcemap.SourceMap;

import java.io.OutputStream;

import static com.atlassian.plugin.webresource.impl.support.Support.getSourceMap;

/**
 * Simple transformer which searches for existing source maps and attaches it to the Content.
 */
public class SourceMapTransformer
{
    public static Content attachPrebuiltSourcemap(final Resource resource, final Content content, final String sourceUrl)
    {
        return new ContentImpl(content.getContentType(), false)
        {
            @Override
            public SourceMap writeTo(final OutputStream out, final boolean isSourceMapEnabled)
            {
                content.writeTo(out, isSourceMapEnabled);
                if (isSourceMapEnabled) {
                    return getSourceMap(resource.getPath(), resource, sourceUrl);
                }
                return null;
            }
        };
    }
}
