package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.elements.ResourceLocation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

/**
 * Virtual resource for JS Module, stub to fit in existing API.
 *
 * @since v3.4.4
 */
public class ModuleResource extends Resource
{
    private final String pluginKey;
    private final LinkedHashMap<String, String> unresolvedDependencies;
    private final LinkedHashSet<String> webResourceDependencies;

    public ModuleResource(WebModule parent, String pluginKey, String filePath, String type,
        LinkedHashMap<String, String> unresolvedDependencies, LinkedHashSet<String> webResourceDependencies)
    {
        super(parent, new ResourceLocation(filePath, filePath, type, null, null, new HashMap<>()), type, type);
        this.pluginKey = pluginKey;
        this.unresolvedDependencies = unresolvedDependencies;
        this.webResourceDependencies = webResourceDependencies;
    }

    /**
     * Plugin key this resource belongs to.
     */
    public String getPluginKey()
    {
        return pluginKey;
    }

    public LinkedHashMap<String, String> getUnresolvedDependencies()
    {
        return unresolvedDependencies;
    }

    public LinkedHashSet<String> getWebResourceDependencies()
    {
        return webResourceDependencies;
    }
}
