package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.prebake.Dimensions;

/**
 * Default implementation of WebResourceAssemblerFactory
 * @since v3.0
 */
public class DefaultWebResourceAssemblerFactory implements PrebakeWebResourceAssemblerFactory
{
    private final Globals globals;

    public DefaultWebResourceAssemblerFactory(Globals globals)
    {
        this.globals = globals;
    }

    public DefaultWebResourceAssemblerFactory(PluginResourceLocator pluginResourceLocator) {
        this(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt());
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder create()
    {
        return new DefaultWebResourceAssemblerBuilder(globals);
    }

    @Override
    public Dimensions computeDimensions()
    {
        Snapshot snapshot = globals.getSnapshot();
        Dimensions d = Dimensions.empty();
        for (CachedCondition condition : snapshot.conditions())
        {
            d = d.product(condition.computeDimensions());
        }
        for (CachedTransformers transformer : snapshot.transformers())
        {
            d = d.product(transformer.computeDimensions(globals.getConfig().getTransformerCache()));
        }
        StaticTransformers staticTransformers = globals.getConfig().getStaticTransformers();
        d = d.product(staticTransformers.computeDimensions());
        return d;
    }

    @Override
    public String computeGlobalStateHash()
    {
        return globals.getConfig().computeGlobalStateHash();
    }

    /**
     * @deprecated since 3.3.2
     */
    @Override
    @Deprecated
    public void clearCache()
    {
        globals.triggerStateChange();
    }
}
