/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.StaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.DimensionAwareWebResourceTransformerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;

public class DefaultStaticTransformers
implements StaticTransformers {
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier) {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public Dimensions computeDimensions() {
        return this.staticTransformersSupplier.computeDimensions();
    }

    @Override
    public void addToUrl(String locationType, TransformerParameters transformerParameters, UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy) {
        for (DimensionAwareWebResourceTransformerFactory transformerFactory : this.transformersForType(locationType)) {
            urlBuildingStrategy.addToUrl((TransformerUrlBuilder)transformerFactory.makeUrlBuilder(transformerParameters), urlBuilder);
        }
    }

    @Override
    public Content transform(Content content, TransformerParameters transformerParameters, ResourceLocation resourceLocation, String filePath, QueryParams queryParams, String sourceUrl) {
        for (DimensionAwareWebResourceTransformerFactory transformerFactory : this.transformersForLocation(resourceLocation)) {
            TransformableResource tr = new TransformableResource(resourceLocation, filePath, ResourceServingHelpers.asDownloadableResource(content));
            content = ResourceServingHelpers.asContent(transformerFactory.makeResourceTransformer(transformerParameters).transform(tr, queryParams), null, true);
        }
        return content;
    }

    private Iterable<DimensionAwareWebResourceTransformerFactory> transformersForType(String locationType) {
        return this.staticTransformersSupplier.get(locationType);
    }

    private Iterable<DimensionAwareWebResourceTransformerFactory> transformersForLocation(ResourceLocation location) {
        return this.staticTransformersSupplier.get(location);
    }
}

