/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.ContentTransformerFactory;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.StaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.url.UrlBuilder;

public class DefaultStaticTransformers
implements StaticTransformers {
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier) {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public void addToUrl(String type, TransformerParameters transformerParameters, UrlBuilder urlBuilder) {
        for (ContentTransformerFactory transformerFactory : this.transformersForType(type)) {
            transformerFactory.makeUrlBuilder(transformerParameters).addToUrl(urlBuilder);
        }
    }

    @Override
    public Content transform(Content content, TransformerParameters transformerParameters, ResourceLocation resourceLocation, QueryParams queryParams, String sourceUrl) {
        for (ContentTransformerFactory transformerFactory : this.transformersForLocation(resourceLocation)) {
            content = transformerFactory.makeResourceTransformer(transformerParameters).transform(content, resourceLocation, queryParams, sourceUrl);
        }
        return content;
    }

    private Iterable<ContentTransformerFactory> transformersForType(String type) {
        return this.staticTransformersSupplier.get(type);
    }

    private Iterable<ContentTransformerFactory> transformersForLocation(ResourceLocation location) {
        return this.staticTransformersSupplier.get(location);
    }
}

