/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.bigpipe;

import com.atlassian.annotations.Internal;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.bigpipe.BigPipeManager;
import com.atlassian.plugin.webresource.bigpipe.FutureCompletionService;
import com.atlassian.plugin.webresource.bigpipe.KeyedValue;
import com.atlassian.plugin.webresource.bigpipe.QueueFutureCompletionService;
import com.atlassian.util.concurrent.Promise;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Internal
public class DefaultBigPipeManager
implements BigPipeManager {
    private final ConcurrentHashMap<String, DefaultBigPipe> bigPipes;
    private final FutureCompletionService<Jsonable> completor = new QueueFutureCompletionService<Jsonable>();

    public DefaultBigPipeManager() {
        this.bigPipes = new ConcurrentHashMap();
    }

    @Override
    public BigPipeManager.BigPipe getBigPipe(String requestId) {
        DefaultBigPipe newBigPipe;
        DefaultBigPipe bigPipe = this.bigPipes.get(requestId);
        if (null == bigPipe && null == (bigPipe = this.bigPipes.putIfAbsent(requestId, newBigPipe = new DefaultBigPipe(requestId, this.completor)))) {
            bigPipe = newBigPipe;
        }
        return bigPipe;
    }

    @Override
    public BigPipeManager.ConsumableBigPipe getConsumableBigPipe(String requestId) {
        return this.bigPipes.get(requestId);
    }

    static final class DefaultBigPipe
    implements BigPipeManager.BigPipe,
    BigPipeManager.ConsumableBigPipe {
        private final String requestId;
        private final FutureCompletionService<Jsonable> completor;

        DefaultBigPipe(String requestId, FutureCompletionService<Jsonable> completor) {
            this.requestId = requestId;
            this.completor = completor;
        }

        @Override
        public BigPipeManager.BigPipe push(String key, Promise<Jsonable> promise) {
            this.completor.add(key, promise);
            return this;
        }

        @Override
        public void cancelRemaining() {
            this.completor.destroy(true);
        }

        @Override
        public Iterable<KeyedValue<Jsonable>> getAvailableContent() {
            return this.completor.poll();
        }

        @Override
        public Iterable<KeyedValue<Jsonable>> waitForContent(long timeout, TimeUnit unit) throws InterruptedException {
            return this.completor.poll(timeout, unit);
        }

        @Override
        public boolean isComplete() {
            return this.completor.isComplete();
        }
    }
}

