/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

class InclusionState {
    private Set<String> webresources;
    private Set<String> contexts;
    private Set<String> dataKeys;

    public InclusionState(Set<String> webresources, Set<String> contexts, Set<String> dataKeys) {
        Preconditions.checkNotNull(webresources);
        Preconditions.checkNotNull(contexts);
        Preconditions.checkNotNull(dataKeys);
        this.webresources = webresources;
        this.contexts = contexts;
        this.dataKeys = dataKeys;
    }

    public InclusionState copy() {
        return new InclusionState(Sets.newHashSet(this.webresources), Sets.newHashSet(this.contexts), Sets.newHashSet(this.dataKeys));
    }

    public void reset(InclusionState that) {
        this.webresources = Sets.newHashSet(that.webresources);
        this.contexts = Sets.newHashSet(that.contexts);
        this.dataKeys = Sets.newHashSet(that.dataKeys);
    }

    public Set<String> getWebresources() {
        return this.webresources;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public Set<String> getDataKeys() {
        return this.dataKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusionState that = (InclusionState)o;
        if (!((Object)this.contexts).equals(that.contexts)) {
            return false;
        }
        if (!((Object)this.dataKeys).equals(that.dataKeys)) {
            return false;
        }
        return ((Object)this.webresources).equals(that.webresources);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.webresources, this.contexts, this.dataKeys});
    }
}

