/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class DefaultUrlBuilder
implements UrlBuilder {
    private final List<String> hashes = Lists.newLinkedList();
    private final Map<String, String> queryString = Maps.newLinkedHashMap();
    private boolean isCdnSupported = true;
    private static final Interner<String> hashInterner = Interners.newWeakInterner();

    @Override
    public void addToHash(String name, Object value) {
        this.hashes.add((String)hashInterner.intern((Object)String.valueOf(value)));
    }

    @Override
    public void addToQueryString(String key, String value) {
        this.queryString.put(key, value);
    }

    public void taint() {
        this.isCdnSupported = false;
    }

    public UrlParameters build() {
        return UrlParameters.of(this.isCdnSupported, this.hashes, this.queryString);
    }

    public void addTo(DefaultUrlBuilder urlBuilder) {
        for (Map.Entry<String, String> entry : this.queryString.entrySet()) {
            urlBuilder.addToQueryString(entry.getKey(), entry.getValue());
        }
        for (String hash : this.hashes) {
            urlBuilder.addToHash(null, hash);
        }
        if (!this.isCdnSupported) {
            urlBuilder.taint();
        }
    }
}

