/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class BatchPluginResource
extends AbstractPluginResource {
    private final String completeKey;
    private final String type;
    private final String name;
    private int hash = 0;

    BatchPluginResource(Globals globals, String completeKey, String type, UrlParameters urlParams, Map<String, String> params, BatchedWebResourceDescriptor batchedWebResourceDescriptor) {
        super(globals, urlParams, params, (Set<BatchedWebResourceDescriptor>)ImmutableSet.of((Object)batchedWebResourceDescriptor));
        this.completeKey = completeKey;
        this.type = type;
        this.name = completeKey + "." + type;
    }

    @Override
    public String getResourceName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        Plugin plugin = this.globals.getConfig().getIntegration().getPluginAccessor().getEnabledPluginModule(this.getCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getCompleteKey() {
        return this.completeKey;
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        return Objects.equal((Object)this.params, (Object)that.params) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        if (this.hash != 0) {
            this.hash = Objects.hashCode((Object[])new Object[]{this.name, this.params});
        }
        return this.hash;
    }

    @Override
    public String getUrl(boolean isAbsolute) {
        return this.globals.getRouter().cloneWithNewUrlMode(isAbsolute).urlFor(this);
    }

    @Override
    public Map<String, String> getParamsWithBatchableParams() {
        return ResourceUtils.mergeParamList(this.params, this.urlParams.toQueryString());
    }

    public String toString() {
        return "[BatchPluginResource " + this.name + "]";
    }
}

